;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

; the level2 jump table
;------------------------------------------------------------------------------
.org (pc+255) & 0xff00

emu1_jtab:	rjmp	emu1_code_00
		rjmp	emu1_code_01
		rjmp	emu1_code_02
		rjmp	emu1_code_03
		rjmp	emu1_code_04
		rjmp	emu1_code_05
		rjmp	emu1_code_06
		rjmp	emu1_code_07
		rjmp	emu1_code_08
		rjmp	emu1_code_09
		rjmp	emu1_code_0a
		rjmp	emu1_code_0b
		rjmp	emu1_code_0c
		rjmp	emu1_code_0d
		rjmp	emu1_code_0e
		rjmp	emu1_code_0f

		rjmp	emu1_code_10
		rjmp	emu1_code_11
		rjmp	emu1_code_12
		rjmp	emu1_code_13
		rjmp	emu1_code_14
		rjmp	emu1_code_15
		rjmp	emu1_code_16
		rjmp	emu1_code_17
		rjmp	emu1_code_18
		rjmp	emu1_code_19
		rjmp	emu1_code_1a
		rjmp	emu1_code_1b
		rjmp	emu1_code_1c
		rjmp	emu1_code_1d
		rjmp	emu1_code_1e
		rjmp	emu1_code_1f

		rjmp	emu1_code_20
		rjmp	emu1_code_21
		rjmp	emu1_code_22
		rjmp	emu1_code_23
		rjmp	emu1_code_24
		rjmp	emu1_code_25
		rjmp	emu1_code_26
		rjmp	emu1_code_27
		rjmp	emu1_code_28
		rjmp	emu1_code_29
		rjmp	emu1_code_2a
		rjmp	emu1_code_2b
		rjmp	emu1_code_2c
		rjmp	emu1_code_2d
		rjmp	emu1_code_2e
		rjmp	emu1_code_2f

		rjmp	emu1_code_30
		rjmp	emu1_code_31
		rjmp	emu1_code_32
		rjmp	emu1_code_33
		rjmp	emu1_code_34
		rjmp	emu1_code_35
		rjmp	emu1_code_36
		rjmp	emu1_code_37
		rjmp	emu1_code_38
		rjmp	emu1_code_39
		rjmp	emu1_code_3a
		rjmp	emu1_code_3b
		rjmp	emu1_code_3c
		rjmp	emu1_code_3d
		rjmp	emu1_code_3e
		rjmp	emu1_code_3f

		rjmp	emu1_code_40
		rjmp	emu1_code_41
		rjmp	emu1_code_42
		rjmp	emu1_code_43
		rjmp	emu1_code_44
		rjmp	emu1_code_45
		rjmp	emu1_code_46
		rjmp	emu1_code_47
		rjmp	emu1_code_48
		rjmp	emu1_code_49
		rjmp	emu1_code_4a
		rjmp	emu1_code_4b
		rjmp	emu1_code_4c
		rjmp	emu1_code_4d
		rjmp	emu1_code_4e
		rjmp	emu1_code_4f

		rjmp	emu1_code_50
		rjmp	emu1_code_51
		rjmp	emu1_code_52
		rjmp	emu1_code_53
		rjmp	emu1_code_54
		rjmp	emu1_code_55
		rjmp	emu1_code_56
		rjmp	emu1_code_57
		rjmp	emu1_code_58
		rjmp	emu1_code_59
		rjmp	emu1_code_5a
		rjmp	emu1_code_5b
		rjmp	emu1_code_5c
		rjmp	emu1_code_5d
		rjmp	emu1_code_5e
		rjmp	emu1_code_5f

		rjmp	emu1_code_60
		rjmp	emu1_code_61
		rjmp	emu1_code_62
		rjmp	emu1_code_63
		rjmp	emu1_code_64
		rjmp	emu1_code_65
		rjmp	emu1_code_66
		rjmp	emu1_code_67
		rjmp	emu1_code_68
		rjmp	emu1_code_69
		rjmp	emu1_code_6a
		rjmp	emu1_code_6b
		rjmp	emu1_code_6c
		rjmp	emu1_code_6d
		rjmp	emu1_code_6e
		rjmp	emu1_code_6f

		rjmp	emu1_code_70
		rjmp	emu1_code_71
		rjmp	emu1_code_72
		rjmp	emu1_code_73
		rjmp	emu1_code_74
		rjmp	emu1_code_75
		rjmp	emu1_code_76
		rjmp	emu1_code_77
		rjmp	emu1_code_78
		rjmp	emu1_code_79
		rjmp	emu1_code_7a
		rjmp	emu1_code_7b
		rjmp	emu1_code_7c
		rjmp	emu1_code_7d
		rjmp	emu1_code_7e
		rjmp	emu1_code_7f

		rjmp	emu1_code_80
		rjmp	emu1_code_81
		rjmp	emu1_code_82
		rjmp	emu1_code_83
		rjmp	emu1_code_84
		rjmp	emu1_code_85
		rjmp	emu1_code_86
		rjmp	emu1_code_87
		rjmp	emu1_code_88
		rjmp	emu1_code_89
		rjmp	emu1_code_8a
		rjmp	emu1_code_8b
		rjmp	emu1_code_8c
		rjmp	emu1_code_8d
		rjmp	emu1_code_8e
		rjmp	emu1_code_8f

		rjmp	emu1_code_90
		rjmp	emu1_code_91
		rjmp	emu1_code_92
		rjmp	emu1_code_93
		rjmp	emu1_code_94
		rjmp	emu1_code_95
		rjmp	emu1_code_96
		rjmp	emu1_code_97
		rjmp	emu1_code_98
		rjmp	emu1_code_99
		rjmp	emu1_code_9a
		rjmp	emu1_code_9b
		rjmp	emu1_code_9c
		rjmp	emu1_code_9d
		rjmp	emu1_code_9e
		rjmp	emu1_code_9f

		rjmp	emu1_code_a0
		rjmp	emu1_code_a1
		rjmp	emu1_code_a2
		rjmp	emu1_code_a3
		rjmp	emu1_code_a4
		rjmp	emu1_code_a5
		rjmp	emu1_code_a6
		rjmp	emu1_code_a7
		rjmp	emu1_code_a8
		rjmp	emu1_code_a9
		rjmp	emu1_code_aa
		rjmp	emu1_code_ab
		rjmp	emu1_code_ac
		rjmp	emu1_code_ad
		rjmp	emu1_code_ae
		rjmp	emu1_code_af

		rjmp	emu1_code_b0
		rjmp	emu1_code_b1
		rjmp	emu1_code_b2
		rjmp	emu1_code_b3
		rjmp	emu1_code_b4
		rjmp	emu1_code_b5
		rjmp	emu1_code_b6
		rjmp	emu1_code_b7
		rjmp	emu1_code_b8
		rjmp	emu1_code_b9
		rjmp	emu1_code_ba
		rjmp	emu1_code_bb
		rjmp	emu1_code_bc
		rjmp	emu1_code_bd
		rjmp	emu1_code_be
		rjmp	emu1_code_bf

		rjmp	emu1_code_c0
		rjmp	emu1_code_c1
		rjmp	emu1_code_c2
		rjmp	emu1_code_c3
		rjmp	emu1_code_c4
		rjmp	emu1_code_c5
		rjmp	emu1_code_c6
		rjmp	emu1_code_c7
		rjmp	emu1_code_c8
		rjmp	emu1_code_c9
		rjmp	emu1_code_ca
		rjmp	emu1_code_cb
		rjmp	emu1_code_cc
		rjmp	emu1_code_cd
		rjmp	emu1_code_ce
		rjmp	emu1_code_cf

		rjmp	emu1_code_d0
		rjmp	emu1_code_d1
		rjmp	emu1_code_d2
		rjmp	emu1_code_d3
		rjmp	emu1_code_d4
		rjmp	emu1_code_d5
		rjmp	emu1_code_d6
		rjmp	emu1_code_d7
		rjmp	emu1_code_d8
		rjmp	emu1_code_d9
		rjmp	emu1_code_da
		rjmp	emu1_code_db
		rjmp	emu1_code_dc
		rjmp	emu1_code_dd
		rjmp	emu1_code_de
		rjmp	emu1_code_df

		rjmp	emu1_code_e0
		rjmp	emu1_code_e1
		rjmp	emu1_code_e2
		rjmp	emu1_code_e3
		rjmp	emu1_code_e4
		rjmp	emu1_code_e5
		rjmp	emu1_code_e6
		rjmp	emu1_code_e7
		rjmp	emu1_code_e8
		rjmp	emu1_code_e9
		rjmp	emu1_code_ea
		rjmp	emu1_code_eb
		rjmp	emu1_code_ec
		rjmp	emu1_code_ed
		rjmp	emu1_code_ee
		rjmp	emu1_code_ef

		rjmp	emu1_code_f0
		rjmp	emu1_code_f1
		rjmp	emu1_code_f2
		rjmp	emu1_code_f3
		rjmp	emu1_code_f4
		rjmp	emu1_code_f5
		rjmp	emu1_code_f6
		rjmp	emu1_code_f7
		rjmp	emu1_code_f8
		rjmp	emu1_code_f9
		rjmp	emu1_code_fa
		rjmp	emu1_code_fb
		rjmp	emu1_code_fc
		rjmp	emu1_code_fd
		rjmp	emu1_code_fe
		rjmp	emu1_code_ff

;------------------------------------------------------------------------------
; 0xcb 0x00		RLC B
;------------------------------------------------------------------------------
emu1_code_00:	z80_rlc reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x01		RLC C
;------------------------------------------------------------------------------
emu1_code_01:	z80_rlc reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x02		RLC D
;------------------------------------------------------------------------------
emu1_code_02:	z80_rlc reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x03		RLC E
;------------------------------------------------------------------------------
emu1_code_03:	z80_rlc reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x04		RLC H
;------------------------------------------------------------------------------
emu1_code_04:	z80_rlc reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x05		RLC L
;------------------------------------------------------------------------------
emu1_code_05:	z80_rlc reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x06		RLC M
;------------------------------------------------------------------------------
emu1_code_06:	getmembyte r16,reg_l,reg_h
		z80_rlc r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x07		RLC A
;------------------------------------------------------------------------------
emu1_code_07:	z80_rlc reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x08		rrc B
;------------------------------------------------------------------------------
emu1_code_08:	z80_rrc reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x09		rrc C
;------------------------------------------------------------------------------
emu1_code_09:	z80_rrc reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0a		rrc D
;------------------------------------------------------------------------------
emu1_code_0a:	z80_rrc reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0b		rrc E
;------------------------------------------------------------------------------
emu1_code_0b:	z80_rrc reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0c		rrc H
;------------------------------------------------------------------------------
emu1_code_0c:	z80_rrc reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0d		rrc L
;------------------------------------------------------------------------------
emu1_code_0d:	z80_rrc reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0e		rrc M
;------------------------------------------------------------------------------
emu1_code_0e:	getmembyte r16,reg_l,reg_h
		z80_rrc r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x0f		rrc A
;------------------------------------------------------------------------------
emu1_code_0f:	z80_rrc reg_a
		rjmp	emu1_rflags		;2


;------------------------------------------------------------------------------
; 0xcb 0x10		rl B
;------------------------------------------------------------------------------
emu1_code_10:	z80_rl reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x11		rl C
;------------------------------------------------------------------------------
emu1_code_11:	z80_rl reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x12		rl D
;------------------------------------------------------------------------------
emu1_code_12:	z80_rl reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x13		rl E
;------------------------------------------------------------------------------
emu1_code_13:	z80_rl reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x14		rl H
;------------------------------------------------------------------------------
emu1_code_14:	z80_rl reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x15		rl L
;------------------------------------------------------------------------------
emu1_code_15:	z80_rl reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x16		rl M
;------------------------------------------------------------------------------
emu1_code_16:	getmembyte r16,reg_l,reg_h
		z80_rl r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x17		rl A
;------------------------------------------------------------------------------
emu1_code_17:	z80_rl reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x18		rr B
;------------------------------------------------------------------------------
emu1_code_18:	z80_rr reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x19		rr C
;------------------------------------------------------------------------------
emu1_code_19:	z80_rr reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1a		rr D
;------------------------------------------------------------------------------
emu1_code_1a:	z80_rr reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1b		rr E
;------------------------------------------------------------------------------
emu1_code_1b:	z80_rr reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1c		rr H
;------------------------------------------------------------------------------
emu1_code_1c:	z80_rr reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1d		rr L
;------------------------------------------------------------------------------
emu1_code_1d:	z80_rr reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1e		rr M
;------------------------------------------------------------------------------
emu1_code_1e:	getmembyte r16,reg_l,reg_h
		z80_rr r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x1f		rr A
;------------------------------------------------------------------------------
emu1_code_1f:	z80_rr reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x20		sla B
;------------------------------------------------------------------------------
emu1_code_20:	z80_sla reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x21		sla C
;------------------------------------------------------------------------------
emu1_code_21:	z80_sla reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x22		sla D
;------------------------------------------------------------------------------
emu1_code_22:	z80_sla reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x23		sla E
;------------------------------------------------------------------------------
emu1_code_23:	z80_sla reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x24		sla H
;------------------------------------------------------------------------------
emu1_code_24:	z80_sla reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x25		sla L
;------------------------------------------------------------------------------
emu1_code_25:	z80_sla reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x26		sla M
;------------------------------------------------------------------------------
emu1_code_26:	getmembyte r16,reg_l,reg_h
		z80_sla r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x27		sla A
;------------------------------------------------------------------------------
emu1_code_27:	z80_sla reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x28		sra B
;------------------------------------------------------------------------------
emu1_code_28:	z80_sra reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x29		sra C
;------------------------------------------------------------------------------
emu1_code_29:	z80_sra reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2a		sra D
;------------------------------------------------------------------------------
emu1_code_2a:	z80_sra reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2b		sra E
;------------------------------------------------------------------------------
emu1_code_2b:	z80_sra reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2c		sra H
;------------------------------------------------------------------------------
emu1_code_2c:	z80_sra reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2d		sra L
;------------------------------------------------------------------------------
emu1_code_2d:	z80_sra reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2e		sra M
;------------------------------------------------------------------------------
emu1_code_2e:	getmembyte r16,reg_l,reg_h
		z80_sra r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x2f		sra A
;------------------------------------------------------------------------------
emu1_code_2f:	z80_sra reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x30		sls B
;------------------------------------------------------------------------------
emu1_code_30:	z80_sls reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x31		sls C
;------------------------------------------------------------------------------
emu1_code_31:	z80_sls reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x32		sls D
;------------------------------------------------------------------------------
emu1_code_32:	z80_sls reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x33		sls E
;------------------------------------------------------------------------------
emu1_code_33:	z80_sls reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x34		sls H
;------------------------------------------------------------------------------
emu1_code_34:	z80_sls reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x35		sls L
;------------------------------------------------------------------------------
emu1_code_35:	z80_sls reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x36		sls M
;------------------------------------------------------------------------------
emu1_code_36:	getmembyte r16,reg_l,reg_h
		z80_sls r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x37		sls A
;------------------------------------------------------------------------------
emu1_code_37:	z80_sls reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x38		srl B
;------------------------------------------------------------------------------
emu1_code_38:	z80_srl reg_b
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x39		srl C
;------------------------------------------------------------------------------
emu1_code_39:	z80_srl reg_c
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3a		srl D
;------------------------------------------------------------------------------
emu1_code_3a:	z80_srl reg_d
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3b		srl E
;------------------------------------------------------------------------------
emu1_code_3b:	z80_srl reg_e
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3c		srl H
;------------------------------------------------------------------------------
emu1_code_3c:	z80_srl reg_h
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3d		srl L
;------------------------------------------------------------------------------
emu1_code_3d:	z80_srl reg_l
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3e		srl M
;------------------------------------------------------------------------------
emu1_code_3e:	getmembyte r16,reg_l,reg_h
		z80_srl r16
		rjmp	emu1_wrflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x3f		srl A
;------------------------------------------------------------------------------
emu1_code_3f:	z80_srl reg_a
		rjmp	emu1_rflags		;2

;------------------------------------------------------------------------------
; 0xcb 0x40		bit 0, B
;------------------------------------------------------------------------------
emu1_code_40:	z80_bit reg_b,0x01

;------------------------------------------------------------------------------
; 0xcb 0x41		bit 0, C
;------------------------------------------------------------------------------
emu1_code_41:	z80_bit reg_c,0x01

;------------------------------------------------------------------------------
; 0xcb 0x42		bit 0, D
;------------------------------------------------------------------------------
emu1_code_42:	z80_bit reg_d,0x01

;------------------------------------------------------------------------------
; 0xcb 0x43		bit 0, E
;------------------------------------------------------------------------------
emu1_code_43:	z80_bit reg_e,0x01

;------------------------------------------------------------------------------
; 0xcb 0x44		bit 0, H
;------------------------------------------------------------------------------
emu1_code_44:	z80_bit reg_h,0x01

;------------------------------------------------------------------------------
; 0xcb 0x45		bit 0, L
;------------------------------------------------------------------------------
emu1_code_45:	z80_bit reg_l,0x01

;------------------------------------------------------------------------------
; 0xcb 0x46		bit 0, M
;------------------------------------------------------------------------------
emu1_code_46:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x01

;------------------------------------------------------------------------------
; 0xcb 0x47		bit 0, A
;------------------------------------------------------------------------------
emu1_code_47:	z80_bit reg_a,0x01

;------------------------------------------------------------------------------
; 0xcb 0x48		bit 1, B
;------------------------------------------------------------------------------
emu1_code_48:	z80_bit reg_b,0x02

;------------------------------------------------------------------------------
; 0xcb 0x49		bit 1, C
;------------------------------------------------------------------------------
emu1_code_49:	z80_bit reg_c,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4a		bit 1, D
;------------------------------------------------------------------------------
emu1_code_4a:	z80_bit reg_d,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4b		bit 1, E
;------------------------------------------------------------------------------
emu1_code_4b:	z80_bit reg_e,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4c		bit 1, H
;------------------------------------------------------------------------------
emu1_code_4c:	z80_bit reg_h,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4d		bit 1, L
;------------------------------------------------------------------------------
emu1_code_4d:	z80_bit reg_l,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4e		bit 1, M
;------------------------------------------------------------------------------
emu1_code_4e:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x02

;------------------------------------------------------------------------------
; 0xcb 0x4f		bit 1, A
;------------------------------------------------------------------------------
emu1_code_4f:	z80_bit reg_a,0x02

;------------------------------------------------------------------------------
; 0xcb 0x50		bit 2, B
;------------------------------------------------------------------------------
emu1_code_50:	z80_bit reg_b,0x04

;------------------------------------------------------------------------------
; 0xcb 0x51		bit 2, C
;------------------------------------------------------------------------------
emu1_code_51:	z80_bit reg_c,0x04

;------------------------------------------------------------------------------
; 0xcb 0x52		bit 2, D
;------------------------------------------------------------------------------
emu1_code_52:	z80_bit reg_d,0x04

;------------------------------------------------------------------------------
; 0xcb 0x53		bit 2, E
;------------------------------------------------------------------------------
emu1_code_53:	z80_bit reg_e,0x04

;------------------------------------------------------------------------------
; 0xcb 0x54		bit 2, H
;------------------------------------------------------------------------------
emu1_code_54:	z80_bit reg_h,0x04

;------------------------------------------------------------------------------
; 0xcb 0x55		bit 2, L
;------------------------------------------------------------------------------
emu1_code_55:	z80_bit reg_l,0x04

;------------------------------------------------------------------------------
; 0xcb 0x56		bit 2, M
;------------------------------------------------------------------------------
emu1_code_56:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x04

;------------------------------------------------------------------------------
; 0xcb 0x57		bit 2, A
;------------------------------------------------------------------------------
emu1_code_57:	z80_bit reg_a,0x04

;------------------------------------------------------------------------------
; 0xcb 0x58		bit 3, B
;------------------------------------------------------------------------------
emu1_code_58:	z80_bit reg_b,0x08

;------------------------------------------------------------------------------
; 0xcb 0x59		bit 3, C
;------------------------------------------------------------------------------
emu1_code_59:	z80_bit reg_c,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5a		bit 3, D
;------------------------------------------------------------------------------
emu1_code_5a:	z80_bit reg_d,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5b		bit 3, E
;------------------------------------------------------------------------------
emu1_code_5b:	z80_bit reg_e,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5c		bit 3, H
;------------------------------------------------------------------------------
emu1_code_5c:	z80_bit reg_h,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5d		bit 3, L
;------------------------------------------------------------------------------
emu1_code_5d:	z80_bit reg_l,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5e		bit 3, M
;------------------------------------------------------------------------------
emu1_code_5e:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x08

;------------------------------------------------------------------------------
; 0xcb 0x5f		bit 3, A
;------------------------------------------------------------------------------
emu1_code_5f:	z80_bit reg_a,0x08

;------------------------------------------------------------------------------
; 0xcb 0x60		bit 4, B
;------------------------------------------------------------------------------
emu1_code_60:	z80_bit reg_b,0x10

;------------------------------------------------------------------------------
; 0xcb 0x61		bit 4, C
;------------------------------------------------------------------------------
emu1_code_61:	z80_bit reg_c,0x10

;------------------------------------------------------------------------------
; 0xcb 0x62		bit 4, D
;------------------------------------------------------------------------------
emu1_code_62:	z80_bit reg_d,0x10

;------------------------------------------------------------------------------
; 0xcb 0x63		bit 4, E
;------------------------------------------------------------------------------
emu1_code_63:	z80_bit reg_e,0x10

;------------------------------------------------------------------------------
; 0xcb 0x64		bit 4, H
;------------------------------------------------------------------------------
emu1_code_64:	z80_bit reg_h,0x10

;------------------------------------------------------------------------------
; 0xcb 0x65		bit 4, L
;------------------------------------------------------------------------------
emu1_code_65:	z80_bit reg_l,0x10

;------------------------------------------------------------------------------
; 0xcb 0x66		bit 4, M
;------------------------------------------------------------------------------
emu1_code_66:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x10

;------------------------------------------------------------------------------
; 0xcb 0x67		bit 4, A
;------------------------------------------------------------------------------
emu1_code_67:	z80_bit reg_a,0x10

;------------------------------------------------------------------------------
; 0xcb 0x68		bit 5, B
;------------------------------------------------------------------------------
emu1_code_68:	z80_bit reg_b,0x20

;------------------------------------------------------------------------------
; 0xcb 0x69		bit 5, C
;------------------------------------------------------------------------------
emu1_code_69:	z80_bit reg_c,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6a		bit 5, D
;------------------------------------------------------------------------------
emu1_code_6a:	z80_bit reg_d,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6b		bit 5, E
;------------------------------------------------------------------------------
emu1_code_6b:	z80_bit reg_e,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6c		bit 5, H
;------------------------------------------------------------------------------
emu1_code_6c:	z80_bit reg_h,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6d		bit 5, L
;------------------------------------------------------------------------------
emu1_code_6d:	z80_bit reg_l,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6e		bit 5, M
;------------------------------------------------------------------------------
emu1_code_6e:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x20

;------------------------------------------------------------------------------
; 0xcb 0x6f		bit 5, A
;------------------------------------------------------------------------------
emu1_code_6f:	z80_bit reg_a,0x20

;------------------------------------------------------------------------------
; 0xcb 0x70		bit 6, B
;------------------------------------------------------------------------------
emu1_code_70:	z80_bit reg_b,0x40

;------------------------------------------------------------------------------
; 0xcb 0x71		bit 6, C
;------------------------------------------------------------------------------
emu1_code_71:	z80_bit reg_c,0x40

;------------------------------------------------------------------------------
; 0xcb 0x72		bit 6, D
;------------------------------------------------------------------------------
emu1_code_72:	z80_bit reg_d,0x40

;------------------------------------------------------------------------------
; 0xcb 0x73		bit 6, E
;------------------------------------------------------------------------------
emu1_code_73:	z80_bit reg_e,0x40

;------------------------------------------------------------------------------
; 0xcb 0x74		bit 6, H
;------------------------------------------------------------------------------
emu1_code_74:	z80_bit reg_h,0x40

;------------------------------------------------------------------------------
; 0xcb 0x75		bit 6, L
;------------------------------------------------------------------------------
emu1_code_75:	z80_bit reg_l,0x40

;------------------------------------------------------------------------------
; 0xcb 0x76		bit 6, M
;------------------------------------------------------------------------------
emu1_code_76:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x40

;------------------------------------------------------------------------------
; 0xcb 0x77		bit 6, A
;------------------------------------------------------------------------------
emu1_code_77:	z80_bit reg_a,0x40

;------------------------------------------------------------------------------
; 0xcb 0x78		bit 7, B
;------------------------------------------------------------------------------
emu1_code_78:	z80_bit reg_b,0x80

;------------------------------------------------------------------------------
; 0xcb 0x79		bit 7, C
;------------------------------------------------------------------------------
emu1_code_79:	z80_bit reg_c,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7a		bit 7, D
;------------------------------------------------------------------------------
emu1_code_7a:	z80_bit reg_d,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7b		bit 7, E
;------------------------------------------------------------------------------
emu1_code_7b:	z80_bit reg_e,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7c		bit 7, H
;------------------------------------------------------------------------------
emu1_code_7c:	z80_bit reg_h,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7d		bit 7, L
;------------------------------------------------------------------------------
emu1_code_7d:	z80_bit reg_l,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7e		bit 7, M
;------------------------------------------------------------------------------
emu1_code_7e:	getmembyte r16,reg_l,reg_h
		z80_bit r16,0x80

;------------------------------------------------------------------------------
; 0xcb 0x7f		bit 7, A
;------------------------------------------------------------------------------
emu1_code_7f:	z80_bit reg_a,0x80

;------------------------------------------------------------------------------
; 0xcb 0x80		res 0, B
;------------------------------------------------------------------------------
emu1_code_80:	z80_res reg_b,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x81		res 0, C
;------------------------------------------------------------------------------
emu1_code_81:	z80_res reg_c,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x82		res 0, D
;------------------------------------------------------------------------------
emu1_code_82:	z80_res reg_d,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x83		res 0, E
;------------------------------------------------------------------------------
emu1_code_83:	z80_res reg_e,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x84		res 0, H
;------------------------------------------------------------------------------
emu1_code_84:	z80_res reg_h,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x85		res 0, L
;------------------------------------------------------------------------------
emu1_code_85:	z80_res reg_l,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x86		res 0, M
;------------------------------------------------------------------------------
emu1_code_86:	getmembyte r16,reg_l,reg_h
		z80_res r16,0
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x87		res 0, A
;------------------------------------------------------------------------------
emu1_code_87:	z80_res reg_a,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x88		res 1, B
;------------------------------------------------------------------------------
emu1_code_88:	z80_res reg_b,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x89		res 1, C
;------------------------------------------------------------------------------
emu1_code_89:	z80_res reg_c,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8a		res 1, D
;------------------------------------------------------------------------------
emu1_code_8a:	z80_res reg_d,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8b		res 1, E
;------------------------------------------------------------------------------
emu1_code_8b:	z80_res reg_e,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8c		res 1, H
;------------------------------------------------------------------------------
emu1_code_8c:	z80_res reg_h,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8d		res 1, L
;------------------------------------------------------------------------------
emu1_code_8d:	z80_res reg_l,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8e		res 1, M
;------------------------------------------------------------------------------
emu1_code_8e:	getmembyte r16,reg_l,reg_h
		z80_res r16,1
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x8f		res 1, A
;------------------------------------------------------------------------------
emu1_code_8f:	z80_res reg_a,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x90		res 2, B
;------------------------------------------------------------------------------
emu1_code_90:	z80_res reg_b,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x91		res 2, C
;------------------------------------------------------------------------------
emu1_code_91:	z80_res reg_c,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x92		res 2, D
;------------------------------------------------------------------------------
emu1_code_92:	z80_res reg_d,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x93		res 2, E
;------------------------------------------------------------------------------
emu1_code_93:	z80_res reg_e,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x94		res 2, H
;------------------------------------------------------------------------------
emu1_code_94:	z80_res reg_h,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x95		res 2, L
;------------------------------------------------------------------------------
emu1_code_95:	z80_res reg_l,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x96		res 2, M
;------------------------------------------------------------------------------
emu1_code_96:	getmembyte r16,reg_l,reg_h
		z80_res r16,2
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x97		res 2, A
;------------------------------------------------------------------------------
emu1_code_97:	z80_res reg_a,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x98		res 3, B
;------------------------------------------------------------------------------
emu1_code_98:	z80_res reg_b,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x99		res 3, C
;------------------------------------------------------------------------------
emu1_code_99:	z80_res reg_c,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9a		res 3, D
;------------------------------------------------------------------------------
emu1_code_9a:	z80_res reg_d,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9b		res 3, E
;------------------------------------------------------------------------------
emu1_code_9b:	z80_res reg_e,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9c		res 3, H
;------------------------------------------------------------------------------
emu1_code_9c:	z80_res reg_h,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9d		res 3, L
;------------------------------------------------------------------------------
emu1_code_9d:	z80_res reg_l,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9e		res 3, M
;------------------------------------------------------------------------------
emu1_code_9e:	getmembyte r16,reg_l,reg_h
		z80_res r16,3
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x9f		res 3, A
;------------------------------------------------------------------------------
emu1_code_9f:	z80_res reg_a,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa0		res 4, B
;------------------------------------------------------------------------------
emu1_code_a0:	z80_res reg_b,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa1		res 4, C
;------------------------------------------------------------------------------
emu1_code_a1:	z80_res reg_c,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa2		res 4, D
;------------------------------------------------------------------------------
emu1_code_a2:	z80_res reg_d,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa3		res 4, E
;------------------------------------------------------------------------------
emu1_code_a3:	z80_res reg_e,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa4		res 4, H
;------------------------------------------------------------------------------
emu1_code_a4:	z80_res reg_h,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa5		res 4, L
;------------------------------------------------------------------------------
emu1_code_a5:	z80_res reg_l,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa6		res 4, M
;------------------------------------------------------------------------------
emu1_code_a6:	getmembyte r16,reg_l,reg_h
		z80_res r16,4
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa7		res 4, A
;------------------------------------------------------------------------------
emu1_code_a7:	z80_res reg_a,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa8		res 5, B
;------------------------------------------------------------------------------
emu1_code_a8:	z80_res reg_b,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xa9		res 5, C
;------------------------------------------------------------------------------
emu1_code_a9:	z80_res reg_c,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xaa		res 5, D
;------------------------------------------------------------------------------
emu1_code_aa:	z80_res reg_d,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xab		res 5, E
;------------------------------------------------------------------------------
emu1_code_ab:	z80_res reg_e,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xac		res 5, H
;------------------------------------------------------------------------------
emu1_code_ac:	z80_res reg_h,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xad		res 5, L
;------------------------------------------------------------------------------
emu1_code_ad:	z80_res reg_l,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xae		res 5, M
;------------------------------------------------------------------------------
emu1_code_ae:	getmembyte r16,reg_l,reg_h
		z80_res r16,5
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xaf		res 5, A
;------------------------------------------------------------------------------
emu1_code_af:	z80_res reg_a,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb0		res 6, B
;------------------------------------------------------------------------------
emu1_code_b0:	z80_res reg_b,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb1		res 6, C
;------------------------------------------------------------------------------
emu1_code_b1:	z80_res reg_c,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb2		res 6, D
;------------------------------------------------------------------------------
emu1_code_b2:	z80_res reg_d,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb3		res 6, E
;------------------------------------------------------------------------------
emu1_code_b3:	z80_res reg_e,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb4		res 6, H
;------------------------------------------------------------------------------
emu1_code_b4:	z80_res reg_h,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb5		res 6, L
;------------------------------------------------------------------------------
emu1_code_b5:	z80_res reg_l,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb6		res 6, M
;------------------------------------------------------------------------------
emu1_code_b6:	getmembyte r16,reg_l,reg_h
		z80_res r16,6
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb7		res 6, A
;------------------------------------------------------------------------------
emu1_code_b7:	z80_res reg_a,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb8		res 7, B
;------------------------------------------------------------------------------
emu1_code_b8:	z80_res reg_b,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xb9		res 7, C
;------------------------------------------------------------------------------
emu1_code_b9:	z80_res reg_c,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xba		res 7, D
;------------------------------------------------------------------------------
emu1_code_ba:	z80_res reg_d,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xbb		res 7, E
;------------------------------------------------------------------------------
emu1_code_bb:	z80_res reg_e,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xbc		res 7, H
;------------------------------------------------------------------------------
emu1_code_bc:	z80_res reg_h,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xbd		res 7, L
;------------------------------------------------------------------------------
emu1_code_bd:	z80_res reg_l,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xbe		res 7, M
;------------------------------------------------------------------------------
emu1_code_be:	getmembyte r16,reg_l,reg_h
		z80_res r16,7
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xbf		res 7, A
;------------------------------------------------------------------------------
emu1_code_bf:	z80_res reg_a,7
		rjmp	emu1_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0xc0		set 0, B
;------------------------------------------------------------------------------
emu1_code_c0:	z80_set reg_b,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc1		set 0, C
;------------------------------------------------------------------------------
emu1_code_c1:	z80_set reg_c,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc2		set 0, D
;------------------------------------------------------------------------------
emu1_code_c2:	z80_set reg_d,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc3		set 0, E
;------------------------------------------------------------------------------
emu1_code_c3:	z80_set reg_e,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc4		set 0, H
;------------------------------------------------------------------------------
emu1_code_c4:	z80_set reg_h,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc5		set 0, L
;------------------------------------------------------------------------------
emu1_code_c5:	z80_set reg_l,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc6		set 0, M
;------------------------------------------------------------------------------
emu1_code_c6:	getmembyte r16,reg_l,reg_h
		z80_set r16,0
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc7		set 0, A
;------------------------------------------------------------------------------
emu1_code_c7:	z80_set reg_a,0
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc8		set 1, B
;------------------------------------------------------------------------------
emu1_code_c8:	z80_set reg_b,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xc9		set 1, C
;------------------------------------------------------------------------------
emu1_code_c9:	z80_set reg_c,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xca		set 1, D
;------------------------------------------------------------------------------
emu1_code_ca:	z80_set reg_d,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xcb		set 1, E
;------------------------------------------------------------------------------
emu1_code_cb:	z80_set reg_e,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xcc		set 1, H
;------------------------------------------------------------------------------
emu1_code_cc:	z80_set reg_h,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xcd		set 1, L
;------------------------------------------------------------------------------
emu1_code_cd:	z80_set reg_l,1
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xce		set 1, M
;------------------------------------------------------------------------------
emu1_code_ce:	getmembyte r16,reg_l,reg_h
		z80_set r16,1
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xcf		set 1, A
;------------------------------------------------------------------------------
emu1_code_cf:	z80_set reg_a,1
		rjmp	emu1_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0xd0		set 2, B
;------------------------------------------------------------------------------
emu1_code_d0:	z80_set reg_b,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd1		set 2, C
;------------------------------------------------------------------------------
emu1_code_d1:	z80_set reg_c,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd2		set 2, D
;------------------------------------------------------------------------------
emu1_code_d2:	z80_set reg_d,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd3		set 2, E
;------------------------------------------------------------------------------
emu1_code_d3:	z80_set reg_e,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd4		set 2, H
;------------------------------------------------------------------------------
emu1_code_d4:	z80_set reg_h,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd5		set 2, L
;------------------------------------------------------------------------------
emu1_code_d5:	z80_set reg_l,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd6		set 2, M
;------------------------------------------------------------------------------
emu1_code_d6:	getmembyte r16,reg_l,reg_h
		z80_set r16,2
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd7		set 2, A
;------------------------------------------------------------------------------
emu1_code_d7:	z80_set reg_a,2
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd8		set 3, B
;------------------------------------------------------------------------------
emu1_code_d8:	z80_set reg_b,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xd9		set 3, C
;------------------------------------------------------------------------------
emu1_code_d9:	z80_set reg_c,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xda		set 3, D
;------------------------------------------------------------------------------
emu1_code_da:	z80_set reg_d,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xdb		set 3, E
;------------------------------------------------------------------------------
emu1_code_db:	z80_set reg_e,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xdc		set 3, H
;------------------------------------------------------------------------------
emu1_code_dc:	z80_set reg_h,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xdd		set 3, L
;------------------------------------------------------------------------------
emu1_code_dd:	z80_set reg_l,3
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xde		set 3, M
;------------------------------------------------------------------------------
emu1_code_de:	getmembyte r16,reg_l,reg_h
		z80_set r16,3
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xdf		set 3, A
;------------------------------------------------------------------------------
emu1_code_df:	z80_set reg_a,3
		rjmp	emu1_loop		;2



;------------------------------------------------------------------------------
; 0xcb 0xe0		set 4, B
;------------------------------------------------------------------------------
emu1_code_e0:	z80_set reg_b,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe1		set 4, C
;------------------------------------------------------------------------------
emu1_code_e1:	z80_set reg_c,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe2		set 4, D
;------------------------------------------------------------------------------
emu1_code_e2:	z80_set reg_d,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe3		set 4, E
;------------------------------------------------------------------------------
emu1_code_e3:	z80_set reg_e,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe4		set 4, H
;------------------------------------------------------------------------------
emu1_code_e4:	z80_set reg_h,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe5		set 4, L
;------------------------------------------------------------------------------
emu1_code_e5:	z80_set reg_l,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe6		set 4, M
;------------------------------------------------------------------------------
emu1_code_e6:	getmembyte r16,reg_l,reg_h
		z80_set r16,4
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe7		set 4, A
;------------------------------------------------------------------------------
emu1_code_e7:	z80_set reg_a,4
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe8		set 5, B
;------------------------------------------------------------------------------
emu1_code_e8:	z80_set reg_b,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xe9		set 5, C
;------------------------------------------------------------------------------
emu1_code_e9:	z80_set reg_c,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xea		set 5, D
;------------------------------------------------------------------------------
emu1_code_ea:	z80_set reg_d,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xeb		set 5, E
;------------------------------------------------------------------------------
emu1_code_eb:	z80_set reg_e,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xec		set 5, H
;------------------------------------------------------------------------------
emu1_code_ec:	z80_set reg_h,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xed		set 5, L
;------------------------------------------------------------------------------
emu1_code_ed:	z80_set reg_l,5
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xee		set 5, M
;------------------------------------------------------------------------------
emu1_code_ee:	getmembyte r16,reg_l,reg_h
		z80_set r16,5
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xef		set 5, A
;------------------------------------------------------------------------------
emu1_code_ef:	z80_set reg_a,5
		rjmp	emu1_loop		;2



;------------------------------------------------------------------------------
; 0xcb 0xf0		set 6, B
;------------------------------------------------------------------------------
emu1_code_f0:	z80_set reg_b,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf1		set 6, C
;------------------------------------------------------------------------------
emu1_code_f1:	z80_set reg_c,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf2		set 6, D
;------------------------------------------------------------------------------
emu1_code_f2:	z80_set reg_d,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf3		set 6, E
;------------------------------------------------------------------------------
emu1_code_f3:	z80_set reg_e,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf4		set 6, H
;------------------------------------------------------------------------------
emu1_code_f4:	z80_set reg_h,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf5		set 6, L
;------------------------------------------------------------------------------
emu1_code_f5:	z80_set reg_l,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf6		set 6, M
;------------------------------------------------------------------------------
emu1_code_f6:	getmembyte r16,reg_l,reg_h
		z80_set r16,6
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf7		set 6, A
;------------------------------------------------------------------------------
emu1_code_f7:	z80_set reg_a,6
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf8		set 7, B
;------------------------------------------------------------------------------
emu1_code_f8:	z80_set reg_b,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xf9		set 7, C
;------------------------------------------------------------------------------
emu1_code_f9:	z80_set reg_c,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xfa		set 7, D
;------------------------------------------------------------------------------
emu1_code_fa:	z80_set reg_d,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xfb		set 7, E
;------------------------------------------------------------------------------
emu1_code_fb:	z80_set reg_e,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xfc		set 7, H
;------------------------------------------------------------------------------
emu1_code_fc:	z80_set reg_h,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xfd		set 7, L
;------------------------------------------------------------------------------
emu1_code_fd:	z80_set reg_l,7
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xfe		set 7, M
;------------------------------------------------------------------------------
emu1_code_fe:	getmembyte r16,reg_l,reg_h
		z80_set r16,7
		putmembyte r16,reg_l,reg_h
		rjmp	emu1_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0xff		set 7, A
;------------------------------------------------------------------------------
emu1_code_ff:	z80_set reg_a,7
		rjmp	emu1_loop		;2

emu1_wrflags:	putmembyte r16,reg_l,reg_h
emu1_rflags:
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_rot)	;1
		ld	reg_f,Z			;2
.else
		ldi	ZH,HIGH(emu_flags_rot*2)	;1
		lpm	reg_f,Z			;2
.endif
		z80_clrnflag			;1 clear N flag
		bld	reg_f,aflag_c		;set carry flag
emu1_loop:
		getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL
		ijmp				;2

emu1_sel:
		getpcbyte ZL			;12/13
		ldi	ZH,HIGH(emu1_jtab)	;1
		ijmp				;2

