;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

monitor_init:	lds	XL,vsys_border
		sts	mon_tborder,XL
		sts	vsys_border,const_1
		ldi	XL,0x0d
		sts	vsys_color,XL
		sts	vsys_view,const_1
		ldi	r19,0x00
		jmp	sys_clear


monitor_step:	sbi	GPIOR0,break_flag			;step
		cbi	GPIOR0,go_flag
		rjmp	monitor_end_1
monitor_end:	cbi	GPIOR0,break_flag			;GO
		cbi	GPIOR0,go_flag
monitor_end_1:	sts	mon_break,ZL
		sts	vsys_keycode,const_0
		sts	vsys_view,const_0
		lds	XL,mon_tborder
		sts	vsys_border,XL
monitor_end_2:	ldi	XL,LOW(vsys_kbuf)
		ldi	XH,HIGH(vsys_kbuf)
		ldi	ZL,16
monitor_end_3:	st	X+,const_ff
		dec	ZL
		brne	monitor_end_3
		ret

;------------------------------------------------------------------------------
; monitor entry
;------------------------------------------------------------------------------
monitor:	rcall	monitor_init

		ldi	XL,0
		ldi	XH,0
		call	sys_gotoxy

		ldi	XL,0x29
		sts	vsys_color,XL
		ldi	ZL,LOW(monitor_itxt*2)
		ldi	ZH,HIGH(monitor_itxt*2)
		call	sys_flashtext
		ldi	XL,0x0d
		sts	vsys_color,XL

monitor_loop:	call	monitor_rview
		rcall	monitor_bview
monitor_loop1:	call	monitor_mview
monitor_loop2:	call	vsys_waitkey
		cpi	r16,'d'			;dump addr
		breq	monitor_duv
		cpi	r16,'b'			;break addr
		breq	monitor_bev
		cpi	r16,0xed		;exit without watch
		breq	monitor_end
		cpi	r16,0x20		;space = step
		breq	monitor_step
		cpi	r16,'v'			;view
		breq	monitor_viewx
		cpi	r16,'g'			;go with watch
		breq	monitor_gox
		cpi	r16,'p'			;set PC
		breq	monitor_pcv
		cpi	r16,0xe4		;up
		breq	monitor_up
		cpi	r16,0xe5		;down
		breq	monitor_down
		cpi	r16,0xe6		;page up
		breq	monitor_pup
		cpi	r16,0xe7		;page down
		breq	monitor_pdown
		rjmp	monitor_loop2

monitor_viewx:	rjmp	monitor_view

monitor_gox:	sbi	GPIOR0,go_flag
		cbi	GPIOR0,break_flag
		rjmp	monitor_end_1

monitor_bev:	rcall	monitor_bedit
		rjmp	monitor_loop

monitor_duv:	rcall	monitor_dedit
		rjmp	monitor_loop

monitor_pcv:	rcall	monitor_pedit
		rjmp	monitor_loop

monitor_up:	lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		subi	XL,0x40
		sbci	XH,0x00

monitor_gloop:	sts	mon_dump_l,XL
		sts	mon_dump_h,XH
		rjmp	monitor_loop1

monitor_down:	lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		ldi	r16,0x40
		add	XL,r16
		adc	XH,const_0
		rjmp	monitor_gloop

monitor_pup:	lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		subi	XH,0x04
		sbc	XH,const_0
		rjmp	monitor_gloop

monitor_pdown:	lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		subi	XH,0xfc
		rjmp	monitor_gloop


monitor_view:	sts	vsys_view,const_0
		lds	XL,mon_tborder
		sts	vsys_border,XL
		call	vsys_waitkey
		lds	XL,vsys_border
		sts	mon_tborder,XL
		sts	vsys_border,const_1
		ldi	XL,0x0d
		sts	vsys_color,XL
		sts	vsys_view,const_1
		rjmp	monitor_loop


monitor_rview:
		ldi	XL,0x0f
		sts	vsys_color,XL
		ldi	XL,0
		ldi	XH,2
		call	sys_gotoxy
		ldi	r19,'P'
		call	sys_char
		ldi	r19,'C'
		call	sys_char
		rcall	monitor_space
		mov	r16,PC_H
		call	sys_hexout
		mov	r16,PC_L
		call	sys_hexout
		movw	XL,PC_L
		rcall	monitor_space

		ldi	r18,5

mon_rv_01:	rcall	monitor_space
		getmembyte r16,XL,XH
		call	sys_hexout
		adiw	XL,1
		dec	r18
		brne	mon_rv_01

		ldi	XL,0
		ldi	XH,4
		call	sys_gotoxy
		ldi	r19,'S'
		call	sys_char
		ldi	r19,'P'
		call	sys_char
		rcall	monitor_space
		mov	r16,SP_H
		call	sys_hexout
		mov	r16,SP_L
		call	sys_hexout
		movw	XL,SP_L
		rcall	monitor_space

		ldi	r18,4

mon_rv_02:	rcall	monitor_space
		adiw	XL,1
		getmembyte r16,XL,XH
		call	sys_hexout
		sbiw	XL,1
		getmembyte r16,XL,XH
		call	sys_hexout
		adiw	XL,2
		dec	r18
		brne	mon_rv_02

		ldi	XL,0
		ldi	XH,6
		call	sys_gotoxy
		ldi	r19,'A'
		call	sys_char
		ldi	r19,'F'
		call	sys_char
		rcall	monitor_space
		mov	r16,reg_a
		call	sys_hexout
		mov	ZL,reg_f
		ldi	ZH,HIGH(ft_avr_z80*2)
		lpm	r16,Z
		sbic	GPIOR0,nflag
		ori	r16,0x02
		push	r16
		call	sys_hexout
		pop	r16
		rcall	monitor_space
		rcall	monitor_space
		rcall	monitor_space
		rcall	monitor_space
		rcall	monitor_space
		ldi	r19,'S'
		rcall	monitor_flagview
		ldi	r19,'Z'
		rcall	monitor_flagview
		ldi	r19,'*'
		rcall	monitor_flagview
		ldi	r19,'H'
		rcall	monitor_flagview
		ldi	r19,'*'
		rcall	monitor_flagview
		ldi	r19,'P'
		rcall	monitor_flagview
		ldi	r19,'N'
		rcall	monitor_flagview
		ldi	r19,'C'
		rcall	monitor_flagview
		ldi	XL,0x0f
		sts	vsys_color,XL


		ldi	XL,0
		ldi	XH,7
		call	sys_gotoxy
		ldi	r19,'B'
		call	sys_char
		ldi	r19,'C'
		call	sys_char
		rcall	monitor_space
		mov	r16,reg_b
		call	sys_hexout
		mov	r16,reg_c
		call	sys_hexout
		rcall	monitor_space
		ldi	r19,'('
		call	sys_char
		getmembyte r16,reg_c,reg_b
		call	sys_hexout
		ldi	r19,')'
		call	sys_char

		ldi	XL,0
		ldi	XH,8
		call	sys_gotoxy
		ldi	r19,'D'
		call	sys_char
		ldi	r19,'E'
		call	sys_char
		rcall	monitor_space
		mov	r16,reg_d
		call	sys_hexout
		mov	r16,reg_e
		call	sys_hexout
		rcall	monitor_space
		ldi	r19,'('
		call	sys_char
		getmembyte r16,reg_e,reg_d
		call	sys_hexout
		ldi	r19,')'
		call	sys_char

		ldi	XL,0
		ldi	XH,9
		call	sys_gotoxy
		ldi	r19,'H'
		call	sys_char
		ldi	r19,'L'
		call	sys_char
		rcall	monitor_space
		mov	r16,reg_h
		call	sys_hexout
		mov	r16,reg_l
		call	sys_hexout
		rcall	monitor_space
		ldi	r19,'('
		call	sys_char
		getmembyte r16,reg_l,reg_h
		call	sys_hexout
		ldi	r19,')'
		call	sys_char


		ldi	XL,0
		ldi	XH,10
		call	sys_gotoxy
		ldi	r19,'I'
		call	sys_char
		ldi	r19,'X'
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_ixh
		call	sys_hexout
		lds	r16,zreg_ixl
		call	sys_hexout

		ldi	XL,13
		ldi	XH,10
		call	sys_gotoxy
		ldi	r19,'I'
		call	sys_char
		ldi	r19,'Y'
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_iyh
		call	sys_hexout
		lds	r16,zreg_iyl
		call	sys_hexout

		ldi	XL,23
		ldi	XH,6
		call	sys_gotoxy
		ldi	r19,'A'
		call	sys_char
		ldi	r19,'F'
		call	sys_char
		ldi	r19,0x27
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_a1
		call	sys_hexout
		lds	ZL,zreg_f1
		ldi	ZH,HIGH(ft_avr_z80*2)
		lpm	r16,Z
		sbic	GPIOR0,nflag
		ori	r16,0x02
		call	sys_hexout

		ldi	XL,23
		ldi	XH,7
		call	sys_gotoxy
		ldi	r19,'B'
		call	sys_char
		ldi	r19,'C'
		call	sys_char
		ldi	r19,0x27
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_b1
		call	sys_hexout
		lds	r16,zreg_c1
		call	sys_hexout

		ldi	XL,23
		ldi	XH,8
		call	sys_gotoxy
		ldi	r19,'D'
		call	sys_char
		ldi	r19,'E'
		call	sys_char
		ldi	r19,0x27
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_d1
		call	sys_hexout
		lds	r16,zreg_e1
		call	sys_hexout


		ldi	XL,23
		ldi	XH,9
		call	sys_gotoxy
		ldi	r19,'H'
		call	sys_char
		ldi	r19,'L'
		call	sys_char
		ldi	r19,0x27
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_h1
		call	sys_hexout
		lds	r16,zreg_l1
		call	sys_hexout


		ldi	XL,0
		ldi	XH,12
		call	sys_gotoxy
		ldi	r19,'R'
		call	sys_char
		ldi	r19,':'
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_r
		call	sys_hexout

		ldi	XL,8
		ldi	XH,12
		call	sys_gotoxy
		ldi	r19,'I'
		call	sys_char
		ldi	r19,':'
		call	sys_char
		rcall	monitor_space
		lds	r16,zreg_i
		call	sys_hexout

		ldi	XL,16
		ldi	XH,12
		call	sys_gotoxy
		ldi	r19,'I'
		call	sys_char
		ldi	r19,'M'
		call	sys_char
		rcall	monitor_space
		lds	r16,z80_imode
		andi	r16,0x03
		call	sys_hexout

		ldi	XL,24
		ldi	XH,12
		call	sys_gotoxy
		ldi	r19,'I'
		call	sys_char
		ldi	r19,'F'
		call	sys_char
		ldi	r19,'F'
		call	sys_char
		ldi	r19,'1'
		call	sys_char
		rcall	monitor_space
		lds	r16,z80_iflag
		andi	r16,0x01
		call	sys_hexout
		ret

monitor_mview:
		ldi	XL,0x0f
		sts	vsys_color,XL
		ldi	XL,0
		ldi	XH,14
		call	sys_gotoxy
		lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		ldi	YL,8
monitor_mv_1:	mov	r16,XH
		call	sys_hexout
		mov	r16,XL
		call	sys_hexout
		rcall	monitor_space
		rcall	monitor_space
		ldi	YH,8
monitor_mv_2:	getmembyte r16,XL,XH
		call	sys_hexout
		adiw	XL,1
		rcall	monitor_space
		dec	YH
		brne	monitor_mv_2
		rcall	monitor_space
		rcall	monitor_space
		dec	YL
		brne	monitor_mv_1
		ret

;-------------------------------------------------------------------------------
; edit PC
;-------------------------------------------------------------------------------
monitor_pedit:	ldi	XL,0x17
		sts	vsys_color,XL
		rcall	monitor_pview1
monitor_pedit1:	call	vsys_waitkey
		cpi	r16,0xea		;enter
		breq	monitor_pview
		cpi	r16,'0'
		brcs	monitor_pedit1
		cpi	r16,'9'+1
		brcs	monitor_pedit2
		cpi	r16,'a'
		brcs	monitor_pedit1
		cpi	r16,'g'
		brcc	monitor_pedit1
		subi	r16,'a'-10
monitor_pedit2:	movw	XL,PC_L
		swap	r16
		ldi	YL,4
monitor_pedit3:	lsl	r16
		rol	XL
		rol	XH
		dec	YL
		brne	monitor_pedit3
		movw	PC_L,XL
		rjmp	monitor_pedit

monitor_pview:	ldi	XL,0x0f
		sts	vsys_color,XL
monitor_pview1:	ldi	XL,3
		ldi	XH,2
		call	sys_gotoxy
		mov	r16,PC_H
		call	sys_hexout
		mov	r16,PC_L
		call	sys_hexout
		ret

;-------------------------------------------------------------------------------
; edit breakpoint
;-------------------------------------------------------------------------------
monitor_bedit:	ldi	XL,0x17
		sts	vsys_color,XL
		rcall	monitor_bview1
monitor_bedit1:	call	vsys_waitkey
		cpi	r16,0xea		;enter
		breq	monitor_bview
		cpi	r16,'0'
		brcs	monitor_bedit1
		cpi	r16,'9'+1
		brcs	monitor_bedit2
		cpi	r16,'a'
		brcs	monitor_bedit1
		cpi	r16,'g'
		brcc	monitor_bedit1
		subi	r16,'a'-10
monitor_bedit2:	lds	XL,mon_break_l
		lds	XH,mon_break_h
		swap	r16
		ldi	YL,4
monitor_bedit3:	lsl	r16
		rol	XL
		rol	XH
		dec	YL
		brne	monitor_bedit3
		sts	mon_break_l,XL
		sts	mon_break_h,XH
		rjmp	monitor_bedit

monitor_bview:	ldi	XL,0x0f
		sts	vsys_color,XL
		ldi	XL,0
		ldi	XH,23
		call	sys_gotoxy
		ldi	ZL,LOW(monitor_btxt*2)
		ldi	ZH,HIGH(monitor_btxt*2)
		call	sys_flashtext
monitor_bview1:	ldi	XL,7
		ldi	XH,23
		call	sys_gotoxy
		lds	XL,mon_break_l
		lds	XH,mon_break_h
		mov	r16,XH
		call	sys_hexout
		mov	r16,XL
		call	sys_hexout
		ret


;-------------------------------------------------------------------------------
; edit dumpaddr
;-------------------------------------------------------------------------------
monitor_dedit:	ldi	XL,0x17
		sts	vsys_color,XL
		rcall	monitor_dview1
monitor_dedit1:	call	vsys_waitkey
		cpi	r16,0xea		;enter
		breq	monitor_dview
		cpi	r16,'0'
		brcs	monitor_dedit1
		cpi	r16,'9'+1
		brcs	monitor_dedit2
		cpi	r16,'a'
		brcs	monitor_dedit1
		cpi	r16,'g'
		brcc	monitor_dedit1
		subi	r16,'a'-10
monitor_dedit2:	lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		swap	r16
		ldi	YL,4
monitor_dedit3:	lsl	r16
		rol	XL
		rol	XH
		dec	YL
		brne	monitor_dedit3
		sts	mon_dump_l,XL
		sts	mon_dump_h,XH
		rjmp	monitor_dedit

monitor_dview:	ldi	XL,0x0f
		sts	vsys_color,XL
monitor_dview1:	ldi	XL,0
		ldi	XH,14
		call	sys_gotoxy
		lds	XL,mon_dump_l
		lds	XH,mon_dump_h
		mov	r16,XH
		call	sys_hexout
		mov	r16,XL
		call	sys_hexout
		ret

monitor_flagview:
		ldi	XL,0x07			;white on black
		sbrc	r16,7
		ldi	XL,0x38			;black on white
		sts	vsys_color,XL
		call	sys_char
		lsl	r16
		ret


monitor_space:	ldi	r19,0x20
		jmp	sys_char

monitor_itxt:	.db "AX82 Monitor V0.25",0x00,0x00
monitor_btxt:	.db "BREAK: ",0x00

