;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# init sequence								#
;# copyright (c) 2005-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;port konfiguration for port A ... D
;-------------------------------------------------------------------------------
vsys_init:	ldi	r16,48
		ldi	XL,LOW(vsys_ram)
		ldi	XH,HIGH(vsys_ram)
vsys_init_r:	st	X+,const_0
		dec	r16
		brne	vsys_init_r
		ldi	XL,LOW(vsys_kbuf)
		ldi	XH,HIGH(vsys_kbuf)
		ldi	r16,9
vsys_init_r1:	st	X+,const_ff
		dec	r16
		brne	vsys_init_r1

		mov	vline_l,const_0
		mov	vline_h,const_0
		ldi	XL,0x09
		sts	vsys_border,XL
		ldi	XL,sys_dfile
		sts	vsys_rampos_h,XL
		sts	vsys_rampos_l,const_0

		;port A config
		ldi	XL,0x00
		out	PORTA,XL
		ldi	XL,0xFF
		out	DDRA,XL

		;port B config
		ldi	XL,0x0a			;SS HIGH
		out	PORTB,XL
		ldi	XL,0xbc
		out	DDRB,XL

		;port C config
		ldi	XL,0x00
		out	PORTC,XL
		ldi	XL,0x00			;input
		out	DDRC,XL

		out	GPIOR0,const_0
vsys_init_cfg:	sbis	PINB,1
		sbi	GPIOR0,7

		;port D config
		ldi	XL,0x10
		out	PORTD,XL
		ldi	XL,0xfa
		out	DDRD,XL

;		cbi	GPIOR0,7		;set VGA
;		sbi	GPIOR0,7		;set TV

;init the kempston interface
vsys_init_ki:	ldi	XL,0x00			;clear U2X
		sts	UCSR1A,XL
		ldi	XL,0x18			;enable RX,TX
		sts	UCSR1B,XL
		ldi	XL,0x06			;8 bit, 1 stop, no parity
		sts	UCSR1C,XL
		ldi	XL,HIGH(vsys_brate)
		sts	UBRR1H,XL
		ldi	XL,LOW(vsys_brate)
		sts	UBRR1L,XL

;-------------------------------------------------------------------------------
;usart configuration (synchronous for keyboard)
;-------------------------------------------------------------------------------
vsys_t2i:	sts	UCSR0A,const_0
		ldi	XL,0x10
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL

		sbic	GPIOR0,7
		rjmp	init_tv

;-------------------------------------------------------------------------------
;timer configuration for VGA
;-------------------------------------------------------------------------------
init_vga:	ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(vsys_counter_v-1)
		ldi	ZL,LOW(vsys_counter_v-1)
		sts	ICR1H,ZH
		sts	ICR1L,ZL

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,vsys_hslen_v		;1 hsync length VGA
		sts	OCR1AL,ZH

		ldi	ZH,HIGH(vsys_hint_v)	;video start position
		sts	OCR1BH,ZH
		ldi	ZH,LOW(vsys_hint_v)
		sts	OCR1BL,ZH

		ldi	XL,0x23			;FAST PWM CHB
		out	TCCR0A,XL
		ldi	XL,0x09
		out	TCCR0B,XL
		ldi	XL,0x01
		out	OCR0A,XL
		ldi	XL,0x00
		out	OCR0B,XL

		ldi	XL,0xbd
init_vga_w2:	dec	XL
		nop
		brne	init_vga_w2

		ldi	XL,0x33
		sts	TCCR2A,XL
		ldi	XL,0x0A
		sts	TCCR2B,XL
		ldi	XL,vsys_counter_v/8-1
		sts	OCR2A,XL
		ldi	XL,vsys_bend_v
		sts	OCR2B,XL

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable CHB INT

		sbi	VSDDR,VSPIN
		sbi	HSDDR,HSPIN

		ldi	XL,LOW(vint_vg0)
		ldi	XH,HIGH(vint_vg0)
		out	GPIOR1,XL
		out	GPIOR2,XH

		ret

;-------------------------------------------------------------------------------
;timer configuration for TV
;-------------------------------------------------------------------------------
init_tv:	ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(vsys_counter_t-1)
		sts	ICR1H,ZH
		ldi	ZH,LOW(vsys_counter_t-1)
		sts	ICR1L,ZH

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,vsys_hslen_t	;1 hsync length TV
		sts	OCR1AL,ZH

		ldi	ZH,HIGH(vsys_hint_t)	;border position
		sts	OCR1BH,ZH
		ldi	ZH,LOW(vsys_hint_t)
		sts	OCR1BL,ZH

		ldi	XL,0x23			;FAST PWM CHB
		out	TCCR0A,XL
		ldi	XL,0x09
		out	TCCR0B,XL
		ldi	XL,0x03
		out	OCR0A,XL
		ldi	XL,0x01
		out	OCR0B,XL

		ldi	XL,0xb8
init_tv_w2:	dec	XL
		nop
		nop
		nop
		nop
		nop
		brne	init_tv_w2

		ldi	XL,0x33
		sts	TCCR2A,XL
		ldi	XL,0x0A
		sts	TCCR2B,XL
		ldi	XL,vsys_counter_t/8-1
		sts	OCR2A,XL
		ldi	XL,vsys_bend_t
		sts	OCR2B,XL

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable CHB INT

		sbi	VSDDR,VSPIN
		sbi	HSDDR,HSPIN

		ldi	XL,LOW(vint_tv0)
		ldi	XH,HIGH(vint_tv0)
		out	GPIOR1,XL
		out	GPIOR2,XH
		ret

;------------------------------------------------------------------------------
;wait for a key
;------------------------------------------------------------------------------
vsys_waitkey:	sts	vsys_lastkey,const_0
vsys_wkey1:	lds	r16,vsys_lastkey
		cpi	r16,0
		breq	vsys_wkey1
		ret

;------------------------------------------------------------------------------
;wait for no key
;------------------------------------------------------------------------------
vsys_nokey:	lds	r16,vsys_keycode
		cpi	r16,0
		brne	vsys_nokey
		sts	vsys_lastkey,const_0
		ret

;------------------------------------------------------------------------------
;	;disable watchdog
;------------------------------------------------------------------------------
vsys_dwd:	wdr
		in	XL,MCUSR
		andi	XL,0xF7
		out	MCUSR,XL
		lds	XL,WDTCSR
		ori	XL,0x18
		sts	WDTCSR,XL
		sts	WDTCSR,const_0
		ret
