;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;save registers (25c)
;-------------------------------------------------------------------------------
vint_vstart:	push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YH			;2 save Y-register
		push	YL			;2 save Y-register
		push	XH			;2 save X-register
		push	XL			;2 save X-register
		in	XL,SREG			;1 save status
		push	XL			;2
		wdr				;1 watchdog reset

;-------------------------------------------------------------------------------
;count line up and select output
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
		in	ZL,GPIOR1
		in	ZH,GPIOR2
		ijmp

vint_tst:	pop	XL
		out	SREG,XL
		pop	XL
		pop	XH
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		reti