;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_tv0:	movw	XL,vline_l
		sbrc	vline_h,0		;1 skip if less than 256
		rjmp	vint_tv0_01		;2 no visible line
		cpi	XL,192			;1 max lines
		brcs	vint_tv0_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_tv0_01:	cpi	XL,vsys_vstart_t
		brne	vint_tv0_02		;no vsync start
		cbi	VSPORT,VSPIN
		ldi	XL,0x82
		sts	TCCR1A,XL
		rjmp	vint_tv0_end

vint_tv0_02:	cpi	XL,vsys_vstop_t
		brne	vint_tv0_03		;no vsync stop
		ldi	XL,0xc2
		sts	TCCR1A,XL
		sbi	VSPORT,VSPIN
		rjmp	vint_tv0_end

vint_tv0_03:	cpi	XL,vsys_vbstart_t
		brne	vint_tv0_04		;no border start
		ldi	XL,0x33
		sts	TCCR2A,XL
		rjmp	vint_tv0_end

vint_tv0_04:	cpi	XL,vsys_vbstop_t
		brne	vint_tv0_05		;no border stop
		ldi	XL,0x03
		sts	TCCR2A,XL
		cbi	PORTD,6			;OFF
		lds	XL,UCSR1A
		sbrc	XL,7
		rjmp	vint_tv0_end		;no data from joystick
		lds	XL,UDR1
		sts	vsys_kempston,XL
		rjmp	vint_tv0_end


vint_tv0_05:	cpi	XL,57
		breq	vint_tv0_06		;2 end of frame
		rjmp	vint_tv0_end

vint_tv0_06:	jmp	vint_frame

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_tv0_10:;	rjmp	vint_tv0_end

vint_tv0_sy0:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,vsys_hstart_t	;1
		brcs	vint_tv0_sy0		;1 loop
vint_tv0_sy_01:	cpi	XL,vsys_hstart_t+1
		brcs	vint_tv0_sy_02
vint_tv0_sy_02:	cpi	XL,vsys_hstart_t+2
		brcs	vint_tv0_sy_03
vint_tv0_sy_03:	cpi	XL,vsys_hstart_t+3
		brcs	vint_tv0_sy_04
vint_tv0_sy_04:	cpi	XL,vsys_hstart_t+4
		brcs	vint_tv0_sy_05
vint_tv0_sy_05:

vint_tv0_vout:	push	r16			;2
		lds	r16,vsys_blink		;2 00/ff
		movw	ZL,vline_l		;2
		lsl	ZL			;1
		rol	ZH			;1
		lsl	ZL			;1
		rol	ZH			;1
		andi	ZH,0x03			;1
		subi	ZH,0x5c			;1
		lpm	XL,Z+			;3
		lpm	XH,Z+			;3
		lpm	YH,Z+			;3
		ldi	YL,32			;1

		sbi	PORTB,2			;2 enable DISPLAY

vint_tv0_vl:	nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		out	PORTA,XL		;1 LOW address
		out	PIND,const_2		;1 register
		out	PORTA,XH		;1 HIGH address PIXDATA
		out	PIND,const_2		;1 switch back register signal
		nop				;1
		nop				;1
		in	ZL,PINC			;1 get PIXDATA
		out	PORTA,YH		;1 HIGH address ATTRDATA
		inc	XL			;1 prepare next LOW addr
		nop				;1
		nop				;1
		in	ZH,PINC			;1 get ATTRDATA
		out	PORTA,ZL		;1 out PIXDATA (C6)
		and	ZH,r16			;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		dec	YL			;1
		out	PORTA,ZH		;1 OUT ATTRDATA (C7)
		brne	vint_tv0_vl		;2

		cbi	PORTB,2			;2 disable display
		lds	YL,vsys_border		;set output to border
		out	PORTA,YL
		pop	r16

vint_tv0_22:	mov	YH,vline_l		;
		andi	YH,0x07
		cpi	YH,0x07
		breq	vint_tv0_end

		pop	XL			;2
		out	SREG,XL			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_tv0_end:	jmp	vsys_keyb

