--------------------------------------------------------------------------------
-- Company: 
-- Engineer:		Joerg Wolfram
--
-- Create Date:		04.12.2011
-- Design Name:
-- Module Name:
-- Project Name:	ax82
-- Target Device:	XC9536-15-PC44
-- Tool versions:
-- Description:		video module
--
-- Revision:		0.10
-- License:		GPL
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--- 00	read
--- 01	write
--- 10	vread
--- 11	cfg

entity mylogik is

port (
-------------------------------------------------------------------------------
--- signals to MCU
-------------------------------------------------------------------------------
	mcu_dat:	in std_logic_vector(7 downto 0);	--- controller data
	mcu_ra:		in std_logic;				--- register address
	mcu_de:		in std_logic;				--- display enable
	mcu_be:		in std_logic;				--- border enable
	mcu_hsync:	in std_logic;				--- horizontal sync
	mcu_pclk:	in std_logic;				--- external pixel clock

-------------------------------------------------------------------------------
--- signals to MEM
-------------------------------------------------------------------------------
	addr_lo:	out std_logic_vector(7 downto 0);
	csel1:		out std_logic;

-------------------------------------------------------------------------------
--- video out
-------------------------------------------------------------------------------
	vout:		out std_logic_vector(3 downto 0)); 	--- video output

end entity mylogik;


architecture version1 of mylogik is

signal	state:		std_logic_vector(2 downto 0);
signal	vreg:		std_logic_vector(8 downto 0);
signal	areg:		std_logic_vector(7 downto 0);
signal	enable:		std_logic;
signal	last_enable:	std_logic;
begin

-------------------------------------------------------------------------------
--- state counter
-------------------------------------------------------------------------------
process(mcu_pclk) is
begin
	if rising_edge(mcu_pclk) then
		if mcu_hsync = '0' then
			state <= "000";
		else
			state <= state + 1;
		end if;
	end if;
end process;

-------------------------------------------------------------------------------
--- low address
-------------------------------------------------------------------------------
process(mcu_ra) is
begin
	if rising_edge(mcu_ra) then
		addr_lo(7 downto 0) <= mcu_dat(7 downto 0);
---		addr_lo(7 downto 0) <= "00000000";
		csel1 <= not(mcu_dat(7));
---		csel1 <= '1';
	end if;
end process;

-------------------------------------------------------------------------------
--- enable data
-------------------------------------------------------------------------------
process(mcu_pclk) is
begin
	if rising_edge(mcu_pclk) then
		if state="101" then
			last_enable <= enable;
			enable <= mcu_de;
		end if;
	end if;
end process;

-------------------------------------------------------------------------------
--- areg
-------------------------------------------------------------------------------
process(mcu_pclk) is
begin
	if rising_edge(mcu_pclk) then
		if state="111" then
			if (enable = '1') then
				areg <= mcu_dat;
			elsif (enable = '0') and (last_enable = '1') then
				areg(2 downto 0) <= mcu_dat(2 downto 0);
				areg(5 downto 3) <= mcu_dat(2 downto 0);
				areg(7 downto 6) <= "00";
			end if;
		end if;
	end if;
end process;


-------------------------------------------------------------------------------
--- vreg
-------------------------------------------------------------------------------
process(mcu_pclk) is
begin
	if rising_edge(mcu_pclk) then
		if (enable = '1') and (state = "110") then
			vreg(7 downto 0) <= mcu_dat;
			vreg(8) <= vreg(7);
		else
			vreg(8 downto 1) <= vreg(7 downto 0);
			vreg(0) <= '0';
		end if;
	end if;
end process;

-------------------------------------------------------------------------------
--- vout
-------------------------------------------------------------------------------
process(mcu_pclk) is
begin
	if falling_edge(mcu_pclk) then
		if mcu_be='1' then
			if vreg(8)/=areg(7) then
				vout(2 downto 0) <= areg(2 downto 0);	---  paper
				if areg(2 downto 0) = "000"
				then
					vout(3) <= '0';
				else
					vout(3) <= areg(6);
				end if;
			else
				vout(2 downto 0) <= areg(5 downto 3);
				if areg(5 downto 3) = "000"
				then
					vout(3) <= '0';
				else
					vout(3) <= areg(6);
				end if;
			end if;
		else
			vout <= "0000";
		end if;
	end if;
end process;

-------------------------------------------------------------------------------
--- minimal configuration
-------------------------------------------------------------------------------
end architecture version1;

configuration main of mylogik is
    for version1
    end for;
end configuration main;
