//###############################################################################
//#										#
//# UPROG2 universal programmer							#
//#										#
//# copyright (c) 2010-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
//#										#
//#										#
//# This program is free software; you can redistribute it and/or		#
//# modify it under the terms of the GNU General Public License			#
//# as published by the Free Software Foundation; either version 3		#
//# of the License, or (at your option) any later version.			#
//#										#
//# This program is distributed in the hope that it will be useful,		#
//# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
//# General Public License for more details.					#
//#										#
//# You should have received a copy of the GNU General Public			#
//# License along with this library// if not, write to the			#
//# Free Software Foundation, Inc., 59 Temple Place - Suite 330,		#
//# Boston, MA 02111-1307, USA.							#
//#										#
//###############################################################################

#define _GNU_SOURCE
#include<netinet/in.h>
#include<sys/socket.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<sys/wait.h>
#include<unistd.h>
#include<fcntl.h>
#include<poll.h>
#include<ncurses.h>

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<termios.h>
#include<unistd.h>
#include<fcntl.h>
#include<signal.h>
#include<sys/ipc.h>
#include<sys/shm.h>

#include <main.h>
#include <algorithm.h>

#include "webserver/uprog2.h"
#include "webserver/uprog2_noprog.h"
#include "webserver/uprog2_illegal.h"
#include "webserver/uprog2_shutdown.h"
#include "webserver/freq1.h"
#include "webserver/freq2.h"
#include "webserver/lanalyzer.h"
#include "webserver/busy.h"
#include "webserver/ready.h"

extern devicedat valid_devices[1000];
extern int daemon_task(void);

int wsprog_connect(void)
{
	int pids,shmid,cstat;
	pid_t mypid;
	
	pids=getpids("uprog2");
	printf("\nuprog2 pids: %d\n",pids);		

	mypid=0;

	if(pids == 1)
	{
		printf("\nuprog2 daemon is not active, starting daemon and searching for programmer...\n\n");		

		mypid=fork();
		
		if(mypid == 0)
		{
			ws_task();
			return 99;
		}
		else
		{	//wait until daemon is active
			usleep(200000);
		}
	}
	printf("uprog2 daemon is active...\n\n");		

	shmid=shmget(1887699,SHM_SIZE,0);
	if(shmid < 0) 
	{
		printf("Shared memory segment is not available. Possible daemon is not active.\n\n"); return 1;
	}
	
	shm=shmat(shmid,NULL,0);
	if(shm == (unsigned char *) -1)
	{
		printf("Cannot attach memory segment.\n\n"); return 1;
	}

	//wait for deamon to find a programmer
	usleep(10000);
	while(shm[0] == 0) usleep(1000);
	
	
	if(shm[0] == 0x1f)
	{
		printf("No programmer found, aborting\n\n"); 
		shm[0]=0;
		sleep(1);					//force exit
		waitpid(-1,&cstat,0);		
		printf("...aborted\n\n"); 
		shmdt(shm);					//detach shared memory
		return 1;
	}

	if(shm[2] == 2)
	{
		printf(">> USB programmer is active.\n\n"); 
		shm[0]=1;					//send ACK to daemon
		interface_type=2;
	}

	if(shm[2] == 1)
	{
		printf(">> Bluetooth programmer is active.\n\n"); 
		shm[0]=1;					//send ACK to daemon
		interface_type=1;
	}

	return 0;
}



int webserver2(void)
{
	int ii,jj,kk;
	int errcode,pstatus,errc;
	int create_socket, comm_socket,flags,i;
	socklen_t addrlen;
	long bufsize = 1024*4096;
	web_buffer = malloc(bufsize);
	struct sockaddr_in address;
	struct pollfd pfd,pkb;
	int end_server = 0;
	long bidx,bptr,ll,zptr,vptr;
	char pdevice[20];
	char pcmd[80];
	int vdd=0;
	size_t sock_rdata;
	is_error=0;
	servermode=1;
	char sendstring[200000];
	char fgen_period[5]="  400";
	char volt_set[7]="       ";
	unsigned short period_val=400;
	int voltage=0;

	int la_divider,la_signals,la_trig_mask,la_trig_polarity,la_zoom,la_scroll;
	unsigned short la_trig_count;
	unsigned long la_winpos;
	int la_active;
	char *rptr;


	printf("Starting server at port 48512...\n"); 

	if ((create_socket = socket(AF_INET, SOCK_STREAM, 0)) > 0)
	{
		   printf("The socket was created\n");
	}

	address.sin_family = AF_INET;
	address.sin_addr.s_addr = INADDR_ANY;
	address.sin_port = htons(48512);		//this our server port

	if (bind(create_socket, (struct sockaddr *) &address, sizeof(address)) == 0)
	{
		   printf("Binding Socket\n");
	}
	else
	{
		   printf("Binding Socket failed\n");
		   exit(1);	
	}

	wsprog_connect();

	while(end_server==0)
	{
		errcode=0;
		hold_vdd=0;

		for(ll=0;ll<bufsize;ll++)
		{
			web_buffer[ll]=0;
		}

		if (listen(create_socket, 10) < 0)
		{
			perror("server: listen");
			exit(1);
		}

		printf("listen...\n");

		flags=fcntl(create_socket,F_GETFL,0);
//		flags |= O_NONBLOCK;
		fcntl(create_socket,F_SETFL,flags);

		pfd.fd=create_socket;
		pfd.events=POLLIN;

		pkb.fd=0;		//stdin
		pkb.events=POLLIN;

		printf("Press Enter to exit server mode...\n");

		do
		{
			i=poll(&pkb,1,100);
			if(i > 0)
			{
				end_server=1;
				close(create_socket);
				free(web_buffer);
				printf("Exiting server...\n");
				return 0;
			}
		
			i=poll(&pfd,1,100);
//			printf("POLL\n");
		}while(i==0);


		if ((comm_socket = accept(create_socket, (struct sockaddr *) &address, &addrlen)) < 0)
		{
			perror("server: accept");
			exit(1);
		}

		printf("comm_sock=%d\n",comm_socket);

		if (comm_socket > 0)
		{
			printf("The Client is connected...\n");
		}	

		sock_rdata=recv(comm_socket, web_buffer, bufsize, 0);
		
		printf("%s\n",web_buffer);

		max_post_data=strlen(web_buffer);
		printf("BLEN=%ld\n",max_post_data);
		for(i=0;i<20;i++)
		{
			web_buffer[max_post_data+i]=0x2e;		//.
		}
		web_buffer[max_post_data+20]=0x00;
		
		bptr=0;
		zptr=0;
		vptr=0;
		
		strcpy(volt_set,"       ");
		
		for(bidx=0;bidx<(max_post_data-8);bidx++)
		{
			if ((web_buffer[bidx] == 'v') 
			&& (web_buffer[bidx+1] == 'd')
			&& (web_buffer[bidx+2] == 'd') 
			&& (web_buffer[bidx+3] == '5')
			&& (web_buffer[bidx+4] == 'v')  
			&& (web_buffer[bidx+5] == '=')
			&& (web_buffer[bidx+6] == 'o')  
			&& (web_buffer[bidx+7] == 'n'))
			{
				 strcpy(volt_set,"checked");
				 vptr=1;
			}
		}
		

		for(bidx=0;bidx<(max_post_data-7);bidx++)
		{
			if ((web_buffer[bidx] == 'p') 
			&& (web_buffer[bidx+1] == 'e')
			&& (web_buffer[bidx+2] == 'r') 
			&& (web_buffer[bidx+3] == 'i')
			&& (web_buffer[bidx+4] == 'o') 
			&& (web_buffer[bidx+5] == 'd') 
			&& (web_buffer[bidx+6] == '=')) zptr=bidx+7;
		}

		
		if(zptr > 0)
		{
			printf("Period found at %d\n",zptr);
		
			period_val=0;
			for(i=0;i<5;i++) fgen_period[i]=0x20;
			i=4;
			zptr+=5;
			ii=6;
			kk=1;
			do
			{
				printf("char: >>%c<<\n",web_buffer[zptr]);
				if((web_buffer[zptr] >= '0') && (web_buffer[zptr] <= '9'))
				{
					printf("digit: %02X\n",web_buffer[zptr]);
					fgen_period[i]=web_buffer[zptr];
					period_val+=kk*(web_buffer[zptr]-0x30);
					i--;
					kk*=10;
				}
				zptr--;
				ii--;
			}while(ii>0);
		}
		
		
		for(bidx=0;bidx<(max_post_data-4);bidx++)
		{
			if ((web_buffer[bidx] == 'd') 
			&& (web_buffer[bidx+1] == 'e')
			&& (web_buffer[bidx+2] == 'v') 
			&&(web_buffer[bidx+3] == '=')) bptr=bidx;
		}

		pstatus=wsprog_connect();
	
		if(pstatus == 99)
		{
			end_server = 1;
			goto WS2_END;
		}

		if(pstatus > 0)
		{
			printf(">>> No programmer...\n");
			write(comm_socket, web_uprog2_noprog, sizeof(web_uprog2_noprog));			
			goto WS2_NXT;
		}
	

		//shut down
		if(strstr(web_buffer,"cmd=-k00"))
		{
			printf(">>> shut down...\n");
			write(comm_socket, web_uprog2_shutdown, sizeof(web_uprog2_shutdown));
			end_server=1;
			prg_comm(0x12f,0,0,0,0,0,0,0,0);			
			goto WS2_NXT;					
		}

		//logic analyzer 1
		if(strstr(web_buffer,"cmd=-l00"))
		{
			printf(">>> LA 00...\n");
			for(i=0;i< sizeof(web_lanalyzer);i++)
			{
				sendstring[i]=web_lanalyzer[i];
			}
			sendstring[sizeof(web_lanalyzer)]=0;
			
			write(comm_socket, sendstring, sizeof(web_lanalyzer));

			goto WS2_NXT;					
		}

		//logic analyzer 2 (modified data)
		if(strstr(web_buffer,"cmd=-l02"))
		{
			printf(">>> LA 02...\n");
			for(i=0;i< sizeof(web_lanalyzer);i++)
			{
				sendstring[i]=web_lanalyzer[i];
			}
			sendstring[sizeof(web_lanalyzer)]=0;
			
			write(comm_socket, sendstring, sizeof(web_lanalyzer));

			goto WS2_NXT;					
		}



		//logic analyzer (start)
		if(strstr(web_buffer,"cmd=-l01"))
		{
			printf(">>> LA START...\n");
			la_active=1;

			//preset values
			la_divider=9;
			la_signals=0x3f;
			la_trig_mask=0x01;
			la_trig_polarity=0x01;
			la_zoom=1;
			la_scroll=100;
			la_trig_count=1;
			la_winpos=0;	

			//now we must parse the string
			rptr=strstr(web_buffer,"div=");
			if(rptr)
			{
				la_divider=atoi(rptr+4);
				printf("### DIVIDER   = %d\n",la_divider);
			}	

			rptr=strstr(web_buffer,"zoom=");
			if(rptr)
			{
				la_zoom=atoi(rptr+5);
				printf("### ZOOM      = %d\n",la_zoom);
			}	

			rptr=strstr(web_buffer,"pos=");
			if(rptr)
			{
				la_winpos=atol(rptr+4);
				printf("### WINPOS    = %ld\n",la_winpos);
			}	

			rptr=strstr(web_buffer,"scr=");
			if(rptr)
			{
				la_scroll=atoi(rptr+4);
				printf("### SCROLL    = %d\n",la_scroll);
			}	


			rptr=strstr(web_buffer,"act=");
			if(rptr)
			{
				la_signals=atoi(rptr+4);
				printf("### ACTIVE    = %02x\n",la_signals);
			}	

			rptr=strstr(web_buffer,"trig=");
			if(rptr)
			{
				la_trig_mask=atoi(rptr+5);
				printf("### TRG-MASK  = %02x\n",la_trig_mask);
			}	

			rptr=strstr(web_buffer,"pol=");
			if(rptr)
			{
				la_trig_polarity=atoi(rptr+5);
				printf("### TRG-POL   = %02x\n",la_trig_polarity);
			}	


			rptr=strstr(web_buffer,"cnt=");
			if(rptr)
			{
				la_trig_count=atoi(rptr+4);
				printf("### TRG-CNT   = %d\n",la_trig_count);
			}	

			memory[0]=la_signals;
			
			if(la_divider == 1)
			{
				printf(">> starting LA at 1M\n");
				errc=prg_comm(0x190,1,0,0,0,	(la_trig_count >> 8) & 0xff,
								(la_trig_count) & 0xff,
								(la_trig_mask) & 0xff,
								(la_trig_polarity) & 0xff);
				la_active=1;
			}

			if(la_divider == 10)
			{
				printf(">> starting LA at 100K\n");
				errc=prg_comm(0x192,1,0,0,0,	(la_trig_count >> 8) & 0xff,
								(la_trig_count) & 0xff,
								(la_trig_mask) & 0xff,
								(la_trig_polarity) & 0xff);
				la_active=1;
			}
			printf(">> LA started\n");
			
			for(i=0;i< sizeof(web_ready);i++)
			{
				sendstring[i]=web_ready[i];
			}
			sendstring[sizeof(web_ready)]=0;
			write(comm_socket, sendstring, sizeof(web_ready));

			goto WS2_NXT;					
		}


		//logic analyzer poll status
		if(strstr(web_buffer,"cmd=-l88"))
		{
			printf(">>> LA poll...\n");
			
			if(la_active == 1)
			{
				ii=prg_comm(0x19F,1,0,0,0,0,0,0,0);
			}
			else
			{
				ii=1;
			}
			
			printf(">>> LA poll...%02X  %02X\n",shm[1],shm[14]);
			
			if(ii==0)
			{
				printf(">>> LA busy...\n");
				for(i=0;i< sizeof(web_busy);i++)
				{
					sendstring[i]=web_busy[i];
				}
				sendstring[sizeof(web_busy)]=0;
				write(comm_socket, sendstring, sizeof(web_busy));
			}
			else		
			{
				printf(">>> LA ready...\n");
				for(i=0;i< sizeof(web_ready);i++)
				{
					sendstring[i]=web_ready[i];
				}
				sendstring[sizeof(web_ready)]=0;
				write(comm_socket, sendstring, sizeof(web_ready));
				la_active=0;
			}
			goto WS2_NXT;					
		}

		//logic analyzer stop
		if(strstr(web_buffer,"cmd=-l99"))
		{
			printf(">>> LA stop...\n");
			
			ii=prg_comm(0x12e,0,0,0,0,0,0,0,0);	//stop
			
			for(i=0;i< sizeof(web_ready);i++)
			{
				sendstring[i]=web_ready[i];
			}
			sendstring[sizeof(web_ready)]=0;
			write(comm_socket, sendstring, sizeof(web_ready));

			goto WS2_NXT;					
		}


		//entry
		if((!(strstr(web_buffer,"cmd="))) || ((strstr(web_buffer,"cmd=-m00"))))
		{
			printf(">>> View startpage...\n");
			write(comm_socket, web_uprog2, sizeof(web_uprog2));
			prg_comm(0xfa,0,0,0,0,0,0,0,0);
			goto WS2_NXT;					
		}

		//re-entry
		if((!(strstr(web_buffer,"cmd="))) || ((strstr(web_buffer,"cmd=-m01"))))
		{
			pstatus=wsprog_connect();
	
			if(pstatus == 99)
			{
				end_server = 1;
				goto WS2_END;
			}
			printf(">>> View startpage...\n");
			write(comm_socket, web_uprog2, sizeof(web_uprog2));
			prg_comm(0xfa,0,0,0,0,0,0,0,0);
			goto WS2_NXT;					
		}


		if(strstr(web_buffer,"cmd=-f00"))
		{
			printf(">>> FGEN 1...\n");
			for(i=0;i< sizeof(web_freq1);i++)
			{
				sendstring[i]=web_freq1[i];
			}
			sendstring[sizeof(web_freq1)]=0;
			for(i=0;i<5;i++)
			{
				sendstring[i+WEB_FREQ1_ZPOS]=fgen_period[i];
			}
			for(i=0;i<7;i++)
			{
				sendstring[i+WEB_FREQ1_VPOS]=volt_set[i];
			}
			
			write(comm_socket, sendstring, sizeof(web_freq1));

			prg_comm(0x12f,0,0,0,0,0,0,0,0);
			prg_comm(0xfa,0,0,0,0,0,0,0,0);

			goto WS2_NXT;					
		}

		//frequency counter 2
		if(strstr(web_buffer,"cmd=-f01"))
		{
			printf(">>> FGEN 2...(%d)\n",period_val);
			
			for(i=0;i< sizeof(web_freq2);i++)
			{
				sendstring[i]=web_freq2[i];
			}
			sendstring[sizeof(web_freq2)]=0;
			for(i=0;i<5;i++)
			{
				sendstring[i+WEB_FREQ2_ZPOS]=fgen_period[i];
			}
			for(i=0;i<7;i++)
			{
				sendstring[i+WEB_FREQ2_VPOS]=volt_set[i];
			}
			
			write(comm_socket, sendstring, sizeof(web_freq2));


			if(vptr==1) prg_comm(0xfb,0,0,0,0,0,0,0,0);
			else prg_comm(0xfa,0,0,0,0,0,0,0,0);

			prg_comm(0x191,0,0,0,0,0,0,period_val & 0xff,(period_val >> 8) & 0xff);
			
			goto WS2_NXT;					
		}


				
		printf(">>> Illegal command...\n");
		write(comm_socket, web_uprog2_illegal, sizeof(web_uprog2_illegal));			
		goto WS2_NXT;	
	
	
	
		pdevice[0]=0;
		ii=0;jj=0;kk=0;
	
		for(bidx=bptr+4;bidx<(bptr+23);bidx++)
		{
			if((web_buffer[bidx] != '&') && (jj == 0))
			{
				pdevice[ii]=web_buffer[bidx];
				pdevice[ii+1]=0;
				ii++;	
			}
			else
			{
				if(jj==0) kk=bidx;
				jj=bidx;
			}
	
		}
	
		bptr=kk+5;
		
		pcmd[0]=0;
		ii=0;jj=0;
	
		for(bidx=bptr;bidx<(bptr+19);bidx++)
		{
			if((web_buffer[bidx] != '&') && (jj == 0))
			{
				pcmd[ii]=web_buffer[bidx];
				pcmd[ii+1]=0;
				ii++;	
			}
			else
			{
				if(jj==0) kk=bidx;			
				jj=bidx;
			}
	
		}
	
		post_data_start=kk+7;
		
		vdd=3;
		if(strstr(pcmd,"5v")) vdd=5;
			
		printf("DEV=%s\n",pdevice);
		printf("CMD=%s\n",pcmd);				
//		printf("%s\n",web_buffer+post_data_start);		
		
		strncpy(cmd,pcmd,78);

		if(cmd[0] == 45) cmd_found=1;
		file_found=2;

		//now search for a valid device
		jj=0;
		dev_found=0;
		do
		{
			if(strncmp(pdevice,valid_devices[jj].name,20) == 0)
			{
				dev_found = 1;
				algo_nr=valid_devices[jj].algo;
				strncpy(name,valid_devices[jj].name,20);
				for(ii=0;ii<19;ii++)
				{
					param[ii]=valid_devices[jj].par[ii];
//					printf("P %2d = %08lx\n",ii,param[ii]);
				}
			}
			jj++;
		}while(strncmp("END",valid_devices[jj].name,20) != 0);
	
		if(dev_found == 0)
		{
			printf("no supported model found\n\n");
			errcode= 1;
		}

		if(cmd_found == 0)
		{
			printf("no command selected\n\n");
			errcode= 2;
		}

		errcode=read_info();
		if(errcode == 0) read_volt();
		if(errcode == 0) check_update();

		if(errcode == 0)
		{
			switch (algo_nr)
			{
				case 1:		errcode=prog_s08();		break;
				case 2:		errcode=prog_r8c();		break;
				case 3:		errcode=prog_avr();		break;
				case 4:		errcode=prog_msp430a();		break;
				case 5:		errcode=prog_msp430b();		break;
				case 6:		errcode=prog_s12xe();		break;
				case 7:		errcode=prog_s12xd();		break;
				case 8:		errcode=prog_stm8();		break;
				case 9:		errcode=prog_c2000();		break;
				case 10:	errcode=prog_dspic33();		break;
				case 11:	errcode=prog_s12xs();		break;
				case 12:	errcode=prog_nec2();		break;
				case 13:	errcode=prog_rl78();		break;
				case 14:	errcode=prog_pic16a();		break;
				case 15:	errcode=prog_pic16b();		break;
				case 16:	errcode=prog_ppcbam();		break;
				case 17:	errcode=prog_pic18a();		break;
				case 18:	errcode=prog_dspic30();		break;
				case 20:	errcode=prog_st7f();		break;
				case 21:	errcode=prog_i2c();		break;
				case 22:	errcode=prog_spiflash();	break;
				case 23:	errcode=prog_dataflash();	break;
				case 30:	errcode=prog_xc9500();		break;
				case 31:	errcode=prog_cc25xx();		break;
				case 32:	errcode=prog_psoc4();		break;
				case 33:	errcode=prog_stm32swd();	break;	//f0
				case 34:	errcode=prog_stm32swd();	break;	//f1
				case 35:	errcode=prog_stm32swd();	break;	//f2
				case 36:	errcode=prog_stm32swd();	break;	//f3
				case 37:	errcode=prog_stm32swd();	break;	//f4
				case 38:	errcode=prog_pic16a();		break;	//pic12
				case 40:	errcode=prog_atxmega();		break;

				case 98:	errcode=prog_rundev();		break;

				default:	errcode=0xaa;
						set_error("WRONG ALGORITHM",2);
						print_error();
			}
		}
		if((algo_nr < 101) && (errcode != 0x9f) && (hold_vdd != 1))
		{
			prg_comm(0xfa,0,0,0,0,0,0,0,0);	//set back to 3,3V mode
		}

		if(errcode == 0x9f)
		{
			printf("FATAL: CONNECTION TO PROGRAMMER LOST!\n");
			printf("   <<< PLEASE RESET PROGRAMMER >>>\n");
			end_server=1;
		}

		if(errcode == 0)
		{
			if((strstr(cmd,"-s5")) || (strstr(cmd,"-s3"))) 
			{		
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 355\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#FFFF60\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Device is running\n",18);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<form action=\"http://localhost:48512\" method=\"post\">\n",53);
				write(comm_socket, "<input type=\"hidden\" name=\"dev\" value=\"RUNDEV\">\n",48);	
				write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s0\">\n",45);
				write(comm_socket, "<input type=\"submit\" value=\"STOP DEVICE\"><form>\n",48);
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);		
			}
			else if(strstr(cmd,"-s0"))
			{
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 255\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#80FF80\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Device stopped\n",15);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<button type=\"button\"",21);
				write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);		
			}
			else
			{
				write(comm_socket, "HTTP/1.1 200 OK\n", 16);
				write(comm_socket, "Content-length: 460\n", 20);
				write(comm_socket, "Content-Type: text/html\n\n", 25);
				write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
				write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#80FF80\">\n",65);
				write(comm_socket, "<center><h3>\n",13);
				write(comm_socket, "Programming done\n",16);
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<button type=\"button\"",21);
				write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
				write(comm_socket, "<br><br>\n",9);
				write(comm_socket, "<form action=\"http://localhost:48512\" method=\"post\">\n",53);
				write(comm_socket, "<input type=\"hidden\" name=\"dev\" value=\"RUNDEV\">\n",48);	
				
				if(vdd==5)
				{
					write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s5\">\n",45);
				}
				else
				{
					write(comm_socket, "<input type=\"hidden\" name=\"cmd\" value=\"-s3\">\n",45);
				}
											
				write(comm_socket, "<input type=\"submit\" value=\"START DEVICE\"><form>\n",49);
				write(comm_socket, "</body></html>\n",15);
				close(comm_socket);
			}		
		}
		else
		{
			write(comm_socket, "HTTP/1.1 200 OK\n", 16);
			write(comm_socket, "Content-length: 339\n", 20);
			write(comm_socket, "Content-Type: text/html\n\n", 25);
			write(comm_socket, "<html><head><title>UPROG2</title></head>\n", 41);
			write(comm_socket, "<body text=\"black\" link=\"black\" vlink=\"black\" bgcolor=\"#FF8080\">\n",65);
			write(comm_socket, "<center><h3>\n",13);
			write(comm_socket, error_line,99);
			write(comm_socket, "<br><br>\n",9);
			write(comm_socket, "<button type=\"button\"",21);
			write(comm_socket, " onclick=\"window.open(\'\',\'_self\',\'\'); window.close();\"> CLOSE TAB </button>\n",76);		
			write(comm_socket, "</body></html>\n",15);
			close(comm_socket);		
		}		
		
WS2_NXT:	
	close(comm_socket);		
WS2_END:
	printf("comm closed (%d)\n",end_server);
	
	}

	return EXIT_SUCCESS;
}
		
		

