;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro getpcbyte
		getmembyte	@0,PC_L,PC_H	;10/11
		adiw	PC_L,1			;2 increment PC
.endmacro

.macro getpcbyte_m1
		getmembyte_m1	ZL,PC_L,PC_H	;10/11
		adiw	PC_L,1			;2 increment PC
		in	ZH,OCR0A
.endmacro

.macro getpcword
		getmemword	@0,@1,PC_L,PC_H
		adiw	PC_L,2			;2 increment PC
.endmacro


.macro getidbyte
		add	r0,@1
		adc	r1,const_0
		sbrc	@1,7
		dec	r1
		getmembyte	@0,r0,r1
;		ld	r0,Y
;		ldd	r1,Y+1
.endmacro

.macro putidbyte
		add	r0,@1
		adc	r1,const_0
		sbrc	@1,7
		dec	r1
		putmembyte	@0,r0,r1
.endmacro

.macro putidbyte1
		putmembyte	@0,r0,r1
.endmacro

.macro z80_setnflag
		sbi	GPIOR0,0
.endm

.macro z80_clrnflag
		cbi	GPIOR0,0
.endm


.macro z80_rlc
		bst	@0,7			;1
		lsl	@0			;1
		bld	@0,0			;1
		mov	ZL,@0			;1
.endm

.macro z80_rl
		lsr	reg_f			;1 shift out carry
		bst	@0,7			;1 save bit 7 for new carry
		rol	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_rrc
		bst	@0,0			;1
		lsr	@0			;1
		bld	@0,7			;1
		mov	ZL,@0			;1
.endm

.macro z80_rr
		mov	r18,reg_f		;1 copy flagbyte
		lsr	r18			;1 shift out carry
		bst	@0,0
		ror	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_sla
		bst	@0,7
		lsl	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_sls
		bst	@0,7
		lsl	@0			;1
		or	@0,const_1
		mov	ZL,@0			;1
.endm

.macro z80_sra
		mov	r18,@0
		lsl	r18
		bst	@0,0
		ror	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_srl
		bst	@0,0
		lsr	@0			;1
		mov	ZL,@0			;1
.endm

.macro z80_bit
		mov	r18,@0
		com	r18
		bst	r18,@1
		bld	reg_f,1
		andi	reg_f,0xfb		;1 clear S
		z80_clrnflag			;1 clear N
		ori	reg_f,flags_seth	;1 set H
.endm

.macro z80_res
		ldi	r18,255-(1<<@1)
		and	@0,r18
.endm

.macro z80_set
		ldi	r18,1<<@1
		or	@0,r18
.endm



.macro reg_add
		add	reg_a,@0
.endm

.macro reg_adc
		lsr	reg_f			;shift out carry
		adc	reg_a,@0
.endm

.macro reg_sub
		sub	reg_a,@0
.endm

.macro reg_sbc
		lsr	reg_f			;shift out carry
		sez				;set zero flag
		sbc	reg_a,@0
.endm

.macro reg_cmp
		cp	reg_a,@0
.endm


.macro z80_increg
		bst	reg_f,aflag_c		;save old carry
		add	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_clrnflag
.endm

.macro z80_inc16
		add	@0,const_1		;+1
		adc	@1,const_0
.endm

.macro z80_decreg
		bst	reg_f,aflag_c		;save old carry
		sub	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_setnflag
.endm

.macro z80_dec16
		sub	@0,const_1		;+1
		sbc	@1,const_0
.endm

.macro z80_add16
		lsr	reg_f			;shift out carry
		add	reg_l,@0
		adc	reg_h,@1
		rol	reg_f			;shift in new carry
		z80_clrnflag			;clear N flag
.endm



.macro z80_loop
		rjmp	emu_loop
.endm


.macro z80_push
		ldi	XL,2
		sub	SP_L,XL
		sbc	SP_H,const_0
		putmemword	@0,@1,SP_L,SP_H
.endm

.macro z80_pop
		getmemword	@0,@1,SP_L,SP_H
		ldi	XL,2
		add	SP_L,XL
		adc	SP_H,const_0
.endm
