;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# Z80 emulator		 							#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro getmembyte_m1	;max. 12 clocks
		mov	ZL,@2			;1 high addr
		mov	ZH,mmap_base		;1
		lpm	ZH,Z			;3 get H byte
		mov	ZL,@1			;1 low addr
		sbrs	ZH,7			;1 skip if ROM
		ld	@0,Z+			;2 get from RAM
		sbrc	ZH,7			;1 skip if RAM
		elpm	@0,Z+			;3 get from ROM
.endmacro

.macro getmembyte	;max. 12 clocks
		mov	ZL,@2			;1 high addr
		mov	ZH,mmap_base		;1
		lpm	ZH,Z			;3 get H byte
		mov	ZL,@1			;1 low addr
		sbrs	ZH,7			;1 skip if ROM
		ld	@0,Z+			;2 get from RAM
		sbrc	ZH,7			;1 skip if RAM
		elpm	@0,Z+			;3 get from ROM
.endmacro

.macro getmemword	;max. 20 clocks
		mov	ZL,@3			;1 high addr
		mov	ZH,mmap_base		;1
		lpm	ZH,Z			;3 get H byte
		mov	ZL,@2			;1 low addr
		sbrs	ZH,7			;1 skip if ROM
		ld	@0,Z+			;2 get from RAM
		sbrc	ZH,7			;1 skip if RAM
		elpm	@0,Z+			;3 get from ROM
		sbrs	ZH,7			;1 skip if ROM
		ld	@1,Z+			;2 get from RAM
		sbrc	ZH,7			;1 skip if RAM
		elpm	@1,Z+			;3 get from ROM
.endmacro

.macro putmembyte	;max. 11 clocks
.if enable_poke == 1
		out	EEARL,@0
.endif
		mov	ZL,@2			;1 get ptr high
		mov	ZH,mmap_base		;1
		lpm	ZH,Z			;3 get H byte
		mov	ZL,@1			;1 get ptr low
		sbrs	ZH,7			;1 skip if ROM
		st	Z+,@0			;2 put to RAM
.if enable_poke == 1
		sbrc	ZH,7
		call	emu_poke
.endif
.endmacro

.macro putmemword	;max. 12 clocks
		mov	ZL,@3			;1 get ptr high
		mov	ZH,mmap_base		;1
		lpm	ZH,Z			;3 get H byte
		mov	ZL,@2			;1 get ptr low
		sbrs	ZH,7			;1 skip if ROM
		st	Z+,@0			;2 put to RAM
		sbrs	ZH,7			;1 skip if ROM
		st	Z+,@1			;2 put to RAM
.endmacro

