;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

fsys_check80:	lds	XL,fsys_status
		sbrc	XL,7
		ret
		ldi	XL,T_ERR
		sts	zx_ram,XL
		pop	r0
		pop	r0
		ret

;------------------------------------------------------------------------------
; save a file
;------------------------------------------------------------------------------
fsys_save_80:	call	fsys_check80

		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	r16,10
		ldi	XL,' '
fsys_s80_1:	st	Y+,XL			;space
		dec	r16
		brne	fsys_s80_1
		lds	ZL,0x209		;4014 in ZX RAM
		lds	ZH,0x20a		;4015 in ZX RAM
		subi	ZL,0x00
		sbci	ZH,0x40
		adiw	ZL,1			;store incl
		st	Y+,ZL
		st	Y+,ZH

		ldi	ZL,0x03			;save with name
		call	fsys_llist
		cpi	ZL,1
		brne	fsys_s80_5
		jmp	fsys_wf80
fsys_s80_5:	ret				;exit with ESC


;------------------------------------------------------------------------------
; load a file
;------------------------------------------------------------------------------
fsys_load_80:	call	fsys_check80

		ldi	YL,LOW(fsys_buf1)	;filename from request
		ldi	YH,HIGH(fsys_buf1)
		ldi	r16,10
		ldi	XL,' '
fsys_l80_1:	st	Y+,XL			;space
		dec	r16
		brne	fsys_l80_1

fsys_l80_5:	ldi	ZL,0x01			;LOAD
		call	fsys_llist
		cpi	ZL,1
		breq	fsys_rf80
		ret				;exit with ESC

;------------------------------------------------------------------------------
; read file
; fsys_tapenr	= tape
; fsys_filenr	= file
;------------------------------------------------------------------------------
fsys_rf80:	sts	fsys_sectnr,const_0	;start with sector 0
		ldi	YL,LOW(fsys_buf2)
		ldi	YH,HIGH(fsys_buf2)
		ldi	XH,17			;read block
		call	fsys_xcmd		;send CMD
		call	fsys_waitsbt		;wait for start block token
		ldi	XH,12			;fname length + len
fsys_rf80_1:	call	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	fsys_rf80_1

		ldi	XH,251			;rest of 512 bytes
fsys_rf80_1a:	call	fsys_write_ff2
		dec	XH
		brne	fsys_rf80_1a

		lds	ZL,fsys_buf2
		cpi	ZL,0x80
		brcc	fsys_rf80_e		;empty file
		lds	ZL,(fsys_flen2_l)	;LEN LOW
		lds	ZH,(fsys_flen2_h)	;LEN HIGH
		ldi	YL,0x00			;start at 0x4000 in Z80 adr space
		ldi	YH,0x02
		sts	fsys_sectnr,const_0	;start data at sector 1-1

fsys_rf80_2:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL
		ldi	XH,17			;read block
		call	fsys_xcmd		;send CMD
		call	fsys_waitsbt		;wait for start block token
		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

fsys_rf80_3:	call	fsys_write_ff		;get data byte
		cp	ZL,const_0
		cpc	ZH,const_0
		breq	fsys_rf80_4		;we must do a dummy read
		st	Y+,XL			;store data byte in RAM
		sbiw	ZL,1			;to-do bytes -1
fsys_rf80_4:	sub	r0,const_1
		sbc	r1,const_0
		brne	fsys_rf80_3
		call	fsys_write_ff2		;get CRC bytes
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		cp	ZL,const_0		;all done?
		cpc	ZH,const_0
		breq	fsys_rf80_e		;yes, we can exit
		rjmp	fsys_rf80_2

fsys_rf80_e:	ret				;all done


;------------------------------------------------------------------------------
; write file
; fsys_tapenr	= tape
; fsys_filenr	= file
;------------------------------------------------------------------------------
fsys_wf80:	sts	fsys_sectnr,const_0	;calc sector addr
		ldi	XH,24			;write block
		call	fsys_xcmd		;send CMD
		ldi	XL,0xfe			;start block token
		call	fsys_wspi		;send
		ldi	YL,LOW(fsys_buf1)
		ldi	YH,HIGH(fsys_buf1)
		ldi	XH,12			;fname length + len
fsys_wf80_1:	ld	XL,Y+
		call	fsys_wspi		;send
		dec	XH
		brne	fsys_wf80_1

		ldi	XH,251			;rest of 512 bytes + CRC
fsys_wf80_1a:	call	fsys_write_ff2		;send
		dec	XH
		brne	fsys_wf80_1a
fsys_wf80_1b:	call	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	fsys_wf80_1b
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		lds	ZL,(fsys_flen1_l)	;LEN LOW
		lds	ZH,(fsys_flen1_h)	;LEN HIGH
		ldi	YL,0x00			;start at 0x4000 in Z80 adr space
		ldi	YH,0x02

fsys_wf80_2:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL

		ldi	XH,24			;write block
		call	fsys_xcmd		;send CMD
		ldi	XL,0xfe			;start block token
		call	fsys_wspi		;send

		clr	r0
		ldi	XL,2
		mov	r1,XL			;512 bytes/sector

fsys_wf80_3:	ldi	XL,0xaa			;dummy byte
		mov	XH,ZL
		or	XH,ZH
		breq	fsys_wf80_4		;we must do a dummy byte write
		ld	XL,Y+			;get next data byte from RAM
		sbiw	ZL,1			;decrement TODO counter

fsys_wf80_4:	call	fsys_wspi		;send
		sub	r0,const_1
		sbc	r1,const_0
		brne	fsys_wf80_3		;sector is not full

		call	fsys_write_ff2		;put dummy CRC bytes
fsys_wf80_5:	call	fsys_write_ff		;put dummy byte
		cpi	XL,0xff
		brne	fsys_wf80_5
		sbi	SPI_SPORT,SPI_SPIN	;CS inactive

		mov	XH,ZL
		or	XH,ZH
		brne	fsys_wf80_2		;not all done
		ret

