;################################################################################
;#										#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vsys_skeys_81:	ldi	ZH,HIGH(kmatrix_zx81/4)
		rjmp	vsys_skeys_1

vsys_skeys_80:	ldi	ZH,HIGH(kmatrix_zx80/4)

vsys_skeys_1:	push	r16
		push	r17
		ldi	r17,0xff
		lds	ZL,vsys_keycode		;get current keycode
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		ldi	r16,0xff
		ldi	XH,8
vsys_skeys_2:	lpm	XL,Z+
		st	Y+,XL
		and	r16,XL
		dec	XH
		brne	vsys_skeys_2
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		std	Y+15,r16
		rjmp	vsys_skeys_s3


vsys_kscan:	ldi	ZH,HIGH(vsys_zktable)
		lds	ZL,vsys_keycode
		lsl	ZL
		rol	ZH
		lpm	reg_l,Z+
		lpm	reg_h,Z+
		lds	ZL,vsys_kbdstate
		sbrc	ZL,2			;CTRL
		or	reg_h,const_1		;remove shift
		ldi	reg_a,0x1f
		ret


vsys_kdecode:	lds	ZL,vsys_lastkey
		ldi	ZH,HIGH(2*zxdec)
		lpm	ZL,Z
		mov	reg_l,ZL
		clr	reg_h
		subi	ZL,0x7d
		mov	reg_e,ZL
		mov	reg_a,ZL
		clr	reg_d
		andi	reg_f,0xfe		;clear C
		lds	ZL,vsys_keycode
		cpi	ZL,0x00			;no valid key
		breq	vsys_kdecode1
		ori	reg_f,0x01		;set C
vsys_kdecode1:	ret


vsys_akscan:	lds	reg_a,vsys_keycode
		ret

showkey:	lds	XL,zx_ram+26
		sts	0x3d1d,XL
		lds	XL,zx_ram+27
		sts	0x3d1e,XL
		lds	XL,zx_ram+28
		sts	0x3d1f,XL
		ldi	XL,0xfe
		sts	0x3d1c,XL
		sts	0x3d1b,reg_a
		ldi	YL,0x20
		ldi	YH,0x3d
		mov	XH,PC_H
		rcall	showhex
		mov	XH,PC_L
		rcall	showhex
		adiw	YL,1
		mov	XH,reg_a
		rcall	showhex
		adiw	YL,1
		mov	XH,reg_b
		rcall	showhex
		mov	XH,reg_c
		rcall	showhex
		adiw	YL,1
		mov	XH,reg_d
		rcall	showhex
		mov	XH,reg_e
		rcall	showhex
		adiw	YL,1
		mov	XH,reg_h
		rcall	showhex
		mov	XH,reg_l
		rcall	showhex
		lds	XL,0x3d40
		inc	XL
		sts	0x3d40,XL
		ret

showhex:
		mov	XL,XH
		swap	XL
		andi	XL,0x0f
		subi	XL,0xd0
		cpi	XL,0x3a
		brcs	showhex_1
		subi	XL,0xf9
showhex_1:	st	Y+,XL
		mov	XL,XH
		andi	XL,0x0f
		subi	XL,0xd0
		cpi	XL,0x3a
		brcs	showhex_2
		subi	XL,0xf9
showhex_2:	st	Y+,XL
		ret

vsys_skeys_sp:	push	r16
		push	r17
		ldi	r17,0xff
		ldi	ZH,HIGH(kmatrix_spec/4)
		lds	ZL,vsys_keycode		;get current keycode
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		ldi	r16,0xff
		ldi	XH,8
vsys_skeys_s2:	lpm	XL,Z+
		and	XL,r17
		st	Y+,XL
		and	r16,XL
		dec	XH
		brne	vsys_skeys_s2
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		lds	XL,vsys_kbdstate
		ldd	XH,Y+7
		andi	XH,0xfd
		sbrc	XL,3			;right CTRL = symbol shift
		std	Y+7,XH
		ld	XH,Y
		andi	XH,0xfe
		sbrc	XL,2			;left CTRL = symbol shift
		st	Y,XH
		std	Y+15,r16
vsys_skeys_s3:	ldd	r16,Y+3			;1 to 0 row
		ldd	r17,Y+4
		and	r16,r17
		std	Y+8,r16
		ldd	r16,Y+2			;Q to P row
		ldd	r17,Y+5
		and	r16,r17
		std	Y+9,r16
		ldd	r16,Y+1			;A to ENT row
		ldd	r17,Y+6
		and	r16,r17
		std	Y+10,r16
		ld	r16,Y			;Z to SP row
		ldd	r17,Y+7
		and	r16,r17
		std	Y+11,r16
		ld	r16,Y			;left column
		ldd	r17,Y+1
		and	r16,r17
		ldd	r17,Y+2
		and	r16,r17
		ldd	r17,Y+3
		and	r16,r17
		std	Y+12,r16
		ldd	r16,Y+4			;left column
		ldd	r17,Y+5
		and	r16,r17
		ldd	r17,Y+6
		and	r16,r17
		ldd	r17,Y+7
		and	r16,r17
		std	Y+13,r16
		pop	r17
		pop	r16
vsys_skeys_s4:	ret

vsys_skeys_ja:	ldi	ZH,HIGH(kmatrix_jace/4)
		push	r16
		push	r17
		ldi	r17,0xff
		lds	ZL,vsys_keycode		;get current keycode
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		lsl	ZL
		rol	ZH
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		ldi	r16,0xff
		ldi	XH,8
vsys_skeys_j2:	lpm	XL,Z+
		st	Y+,XL
		and	r16,XL
		dec	XH
		brne	vsys_skeys_j2
		ldi	YL,LOW(vsys_kbuf)
		ldi	YH,HIGH(vsys_kbuf)
		std	Y+15,r16
		lds	XL,vsys_kbdstate
		ld	XH,Y
		sbrc	XL,2			;right CTRL = symbol shift
		andi	XH,0xfd
		sbrc	XL,3			;right CTRL = symbol shift
		andi	XH,0xfe
		st	Y,XH
		rjmp	vsys_skeys_s3
