;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vint_lc2_fill:
		ldi	ZH,0x0a
		sbrc	vline_l,0
		ldi	ZH,0x05
		rjmp	vint_lc2_bla_0

vint_lc2_blank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

vint_lc2_bla_0:	ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
vint_lc2_bla_1:	out	DPIN,YL			;CP
		dec	XL
		out	DPIN,YL			;/CP
		brne	vint_lc2_bla_1
		sts	vsys_lastnib,ZH
		rjmp	vint_lc2_end

vint_lc2_sblank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f
		ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,1
		rjmp	vint_lc2_bla_1

vint_lc2_fblank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

		ldi	ZL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
vint_lc2_fbl_1:	out	DPIN,ZL			;CP
		dec	XL
		out	DPIN,ZL			;/CP
		brne	vint_lc2_fbl_1
		ldi	ZH,0x20
		sbic	GPIOR0,7
		ldi	ZH,0x2f
		sts	vsys_lastnib,ZH
		rjmp	vint_lc2_end

;-------------------------------------------------------------------------------
; video output
;-------------------------------------------------------------------------------
vint_lc2:	cbi	DPORT,4			;enable display

;count up line counter
		ldi	YL,0x80
		lds	ZH,vsys_lastnib
		out	DPORT,ZH
		sbi	DPORT,6			;set LD
		nop
		out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		nop
		cbi	DPORT,6			;clear LD

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
		mov	ZH,vline_l
		cpi	ZH,0
		breq	vint_lc2_fblank		;first blank line
		cpi	ZH,24
		brcs	vint_lc2_sblank		;upper blank view
		cpi	ZH,216
		brcs	vint_lc2_10
		breq	vint_lc2_blank_x
		cpi	ZH,240
		brcs	vint_lc2_sblank
		jmp	vint_frame

vint_lc2_blank_x:	rjmp	vint_lc2_blank

;-------------------------------------------------------------------------------
; LCD output
;-------------------------------------------------------------------------------
vint_lc2_10:	sbic	GPIOR0,fast_flag
;		rjmp	vint_lc2_fill
		rjmp	vint_lc2_sblank

		clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

		ldi	YL,0x80
		out	DPORT,ZH		;set to border
		ldi	XL,8
vint_lc2_12:	out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		dec	XL
		brne	vint_lc2_12

		lds	XL,vsys_rampos_l	;RAM pointer
		lds	XH,vsys_rampos_h
		mov	YH,vline_l		;
		subi	YH,24
		andi	YH,0x07
		cpi	YH,0x07
		in	YL,SREG
		bst	YL,1			;save flag

		ldi	ZH,HIGH(vsys_ctable*2)
		add	ZH,ZL

		ldi	YL,0x80			;CP pin
		push	r20			;save additional registers
		push	r21

		ldi	r21,66			;chars to do * 2

vint_lc2_14:	ld	ZL,X			;2 get char
		sbrc	ZL,6			;1
		rjmp	vint_lc2_15		;1 bit 6 is set
		adiw	XL,1
		mov	r20,ZL			;1 copy
		ldi	ZH,0x3a			;1 RAM base
		sbrc	r20,7
		ldi	ZH,0x3c			;1 RAM base
		lsl	ZL
		lsl	ZL
		lsl	ZL
		adc	ZH,const_0
		add	ZL,YH
		ld	ZL,Z
		sbrc	r20,7
		com	ZL
		sbic	GPIOR0,7
		com	ZL

		mov	ZH,ZL			;1 copy pixline for second nibble
		swap	ZH
		andi	ZH,0x0f			;1 mask unused bits
		out	DPORT,ZH		;1 out 4 bits
		out	DPIN,YL			;CP
		andi	ZL,0x0f			;1 mask
		out	DPIN,YL			;/CP
		out	DPORT,ZL
		out	DPIN,YL			;CP
		subi	r21,2
		out	DPIN,YL			;/CP
		brne	vint_lc2_14

vint_lc2_15:	subi	r21,0xfb		;+5
		clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f
		out	DPORT,ZH

vint_lc2_17:	out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		dec	r21
		brne	vint_lc2_17
		sts	vsys_lastnib,ZH
		pop	r21
		pop	r20

		brts	vint_lc2_20

		jmp	vsys_kir_end

vint_lc2_20:	adiw	XL,1
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH
;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
vint_lc2_end:	jmp	vsys_keyb
