;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg0:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg0_01		;2 no visible line
		cpi	XL,192			;1 max lines
		brcs	vint_vg0_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg0_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg0_02		;no vsync start
		cbi	VSPORT,VSPIN
		rjmp	vint_vg0_end

vint_vg0_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg0_03		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	vint_vg0_end

vint_vg0_03:	cpi	XL,vsys_vbstart_v
		brne	vint_vg0_04		;no border start
		sbic	GPIOR0,fast_flag
		rjmp	vint_vg0_end
		sbi	GPIOR0,4
		rjmp	vint_vg0_end

vint_vg0_04:	cpi	XL,vsys_vbstop_v
		brne	vint_vg0_05		;no border stop
		cbi	GPIOR0,4
		rjmp	vint_vg0_end

vint_vg0_05:	cpi	XL,7
		breq	vint_vg0_06		;2 end of frame
		rjmp	vint_vg0_end

vint_vg0_06:	jmp	vint_frame

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg0_10:	sbic	GPIOR0,fast_flag
		rjmp	vint_vg0_end

vint_vg0_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_vg0_12
vint_vg0_12:	sbrs	YL,1
		lpm	r13,Z

vint_vg0_16:	ldi	ZL,0x18
		sts	UCSR1B,ZL
		mov	ZL,vline_l		;
		andi	ZL,0x0f
		mov	YH,ZL
		lsr	ZL
		ldi	ZH,HIGH(vsys_ctable*2)
		add	ZH,ZL
		lds	XL,vsys_rampos_l	;get RAM position
		lds	XH,vsys_rampos_h
		ldi	YL,32			;chars to do

vint_vg0_20:	ld	ZL,X			;2
		sbrc	ZL,6			;1
		rjmp	vint_vg0_22		;1 vg3
		lpm	ZL,Z			;3
		sts	UDR1,ZL			;2
		adiw	XL,1			;2
		nop				;1
		nop				;1
		dec	YL			;1
		brne	vint_vg0_20		;2

vint_vg0_22:	sts	UCSR1B,const_0
		cpi	YH,0x0f
		breq	vint_vg0_24

		out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_vg0_24:	adiw	XL,1			;skip next halt
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

vint_vg0_end:	jmp	vsys_keyb
