;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;RST
;------------------------------------------------------------------------------
emu_brake:
		sbic	GPIOR0,6
		rjmp	emu_brake_ntsc
		sbic	GPIOR0,5
		rjmp	emu_brake_lcd

emu_brake_vga:
.if clock_freq == 20
		ldi	ZH,5
.endif
.if clock_freq == 24
		ldi	ZH,19
.endif
.if clock_freq == 25
		ldi	ZH,19
.endif
emu_brake_vga1:	dec	ZH
		brne	emu_brake_vga1
		ldi	ZH,HIGH(emu_jtab)
		ijmp

emu_brake_ntsc:
		sbic	GPIOR0,5
		rjmp	emu_brake_pal
.if clock_freq == 12
		ldi	ZH,HIGH(emu_jtab)
		ijmp
.endif
.if clock_freq == 14
		ldi	ZH,9
.endif
.if clock_freq == 20
		ldi	ZH,21
.endif
.if clock_freq == 24
		ldi	ZH,21
.endif
.if clock_freq == 25
		ldi	ZH,25
.endif
emu_brake_tv2:	dec	ZH
		brne	emu_brake_tv2
		ldi	ZH,HIGH(emu_jtab)
		ijmp

emu_brake_pal:
		sbis	GPIOR0,5
		rjmp	emu_brake_ntsc
.if clock_freq == 12
		ldi	ZH,1
.endif
.if clock_freq == 14
		ldi	ZH,11
.endif
.if clock_freq == 24
		ldi	ZH,28
.endif
.if clock_freq == 25
		ldi	ZH,31
.endif
emu_brake_tv1:	dec	ZH
		brne	emu_brake_tv1
		ldi	ZH,HIGH(emu_jtab)
		ijmp

emu_brake_lcd:
.if clock_freq == 12
		ldi	ZH,HIGH(emu_jtab)
		ijmp
.endif
.if clock_freq == 14
		ldi	ZH,HIGH(emu_jtab)
		ijmp
.endif
.if clock_freq == 20
		ldi	ZH,15
.endif
.if clock_freq == 24
		ldi	ZH,30
.endif
.if clock_freq == 25
		ldi	ZH,33
.endif
emu_brake_lcd1:	dec	ZH
		brne	emu_brake_lcd1
		ldi	ZH,HIGH(emu_jtab)
		ijmp

;------------------------------------------------------------------------------
; the level1 jump table for interrupt
;------------------------------------------------------------------------------

.org (pc+255) & 0xff00

emu_jbtab:	rjmp	emu_brake			;code 0x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake

		rjmp	emu_brake			;code 1x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 2x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 3x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake

		rjmp	emu_brake			;code 4x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 5x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 6x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 7x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 8x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code 9x
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code ax
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code bx
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code cx
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code dx
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code ex
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake


		rjmp	emu_brake			;code fx
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake
		rjmp	emu_brake

