;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; 0xcb 0x00		RLC Id+d,B
;------------------------------------------------------------------------------
emu8_code_00:	z80_rlc r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x01		RLC Id+d,C
;------------------------------------------------------------------------------
emu8_code_01:	z80_rlc r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x02		RLC Id+d,D
;------------------------------------------------------------------------------
emu8_code_02:	z80_rlc r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x03		RLC Id+d,E
;------------------------------------------------------------------------------
emu8_code_03:	z80_rlc r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x04		RLC Id+d,H
;------------------------------------------------------------------------------
emu8_code_04:	z80_rlc r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x05		RLC Id+d,L
;------------------------------------------------------------------------------
emu8_code_05:	z80_rlc r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x06		RLC Id+d
;------------------------------------------------------------------------------
emu8_code_06:	z80_rlc r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x07		RLC Id+d,A
;------------------------------------------------------------------------------
emu8_code_07:	z80_rlc r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x08		RRC Id+d,B
;------------------------------------------------------------------------------
emu8_code_08:	z80_rrc r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x09		RRC Id+d,C
;------------------------------------------------------------------------------
emu8_code_09:	z80_rrc r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0a		RRC Id+d,D
;------------------------------------------------------------------------------
emu8_code_0a:	z80_rrc r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0b		RRC Id+d,E
;------------------------------------------------------------------------------
emu8_code_0b:	z80_rrc r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0c		RRC Id+d,H
;------------------------------------------------------------------------------
emu8_code_0c:	z80_rrc r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0d		RRC Id+d,L
;------------------------------------------------------------------------------
emu8_code_0d:	z80_rrc r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0e		RRC Id+d
;------------------------------------------------------------------------------
emu8_code_0e:	z80_rrc r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x0f		RRC Id+d,A
;------------------------------------------------------------------------------
emu8_code_0f:	z80_rrc r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2


;------------------------------------------------------------------------------
; 0xcb 0x10		RL Id+d,B
;------------------------------------------------------------------------------
emu8_code_10:	z80_rl r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x11		RL Id+d,C
;------------------------------------------------------------------------------
emu8_code_11:	z80_rl r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x12		RL Id+d,D
;------------------------------------------------------------------------------
emu8_code_12:	z80_rl r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x13		RL Id+d,E
;------------------------------------------------------------------------------
emu8_code_13:	z80_rl r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x14		RL Id+d,H
;------------------------------------------------------------------------------
emu8_code_14:	z80_rl r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x15		RL Id+d,L
;------------------------------------------------------------------------------
emu8_code_15:	z80_rl r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x16		RL Id+d
;------------------------------------------------------------------------------
emu8_code_16:	z80_rl r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x17		RL Id+d,A
;------------------------------------------------------------------------------
emu8_code_17:	z80_rl r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x18		RR Id+d,B
;------------------------------------------------------------------------------
emu8_code_18:	z80_rr r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x19		RR Id+d,C
;------------------------------------------------------------------------------
emu8_code_19:	z80_rr r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1a		RR Id+d,D
;------------------------------------------------------------------------------
emu8_code_1a:	z80_rr r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1b		RR Id+d,E
;------------------------------------------------------------------------------
emu8_code_1b:	z80_rr r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1c		RR Id+d,H
;------------------------------------------------------------------------------
emu8_code_1c:	z80_rr r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1d		RR Id+d,L
;------------------------------------------------------------------------------
emu8_code_1d:	z80_rr r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1e		RR Id+d
;------------------------------------------------------------------------------
emu8_code_1e:	z80_rr r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x1f		RR Id+d,A
;------------------------------------------------------------------------------
emu8_code_1f:	z80_rr r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2


;------------------------------------------------------------------------------
; 0xcb 0x20		SLA Id+d,B
;------------------------------------------------------------------------------
emu8_code_20:	z80_sla r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x21		SLA Id+d,C
;------------------------------------------------------------------------------
emu8_code_21:	z80_sla r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x22		SLA Id+d,D
;------------------------------------------------------------------------------
emu8_code_22:	z80_sla r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x23		SLA Id+d,E
;------------------------------------------------------------------------------
emu8_code_23:	z80_sla r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x24		SLA Id+d,H
;------------------------------------------------------------------------------
emu8_code_24:	z80_sla r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x25		SLA Id+d,L
;------------------------------------------------------------------------------
emu8_code_25:	z80_sla r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x26		SLA Id+d
;------------------------------------------------------------------------------
emu8_code_26:	z80_sla r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x27		SLA Id+d,A
;------------------------------------------------------------------------------
emu8_code_27:	z80_sla r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2


;------------------------------------------------------------------------------
; 0xcb 0x28		SRA Id+d,B
;------------------------------------------------------------------------------
emu8_code_28:	z80_sra r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x29		SRA Id+d,C
;------------------------------------------------------------------------------
emu8_code_29:	z80_sra r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2a		SRA Id+d,D
;------------------------------------------------------------------------------
emu8_code_2a:	z80_sra r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2b		SRA Id+d,E
;------------------------------------------------------------------------------
emu8_code_2b:	z80_sra r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2c		SRA Id+d,H
;------------------------------------------------------------------------------
emu8_code_2c:	z80_sra r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2d		SRA Id+d,L
;------------------------------------------------------------------------------
emu8_code_2d:	z80_sra r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2e		SRA Id+d
;------------------------------------------------------------------------------
emu8_code_2e:	z80_sra r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x2f		SRA Id+d,A
;------------------------------------------------------------------------------
emu8_code_2f:	z80_sra r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x30		SLS Id+d,B
;------------------------------------------------------------------------------
emu8_code_30:	z80_sls r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x31		SLS Id+d,C
;------------------------------------------------------------------------------
emu8_code_31:	z80_sls r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x32		SLS Id+d,D
;------------------------------------------------------------------------------
emu8_code_32:	z80_sls r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x33		SLS Id+d,E
;------------------------------------------------------------------------------
emu8_code_33:	z80_sls r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x34		SLS Id+d,H
;------------------------------------------------------------------------------
emu8_code_34:	z80_sls r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x35		SLS Id+d,L
;------------------------------------------------------------------------------
emu8_code_35:	z80_sls r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x36		SLS Id+d
;------------------------------------------------------------------------------
emu8_code_36:	z80_sls r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x37		SLS Id+d,A
;------------------------------------------------------------------------------
emu8_code_37:	z80_sls r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2


;------------------------------------------------------------------------------
; 0xcb 0x38		srl Id+d,B
;------------------------------------------------------------------------------
emu8_code_38:	z80_srl r16
		mov	reg_b,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x39		srl Id+d,C
;------------------------------------------------------------------------------
emu8_code_39:	z80_srl r16
		mov	reg_c,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3a		srl Id+d,D
;------------------------------------------------------------------------------
emu8_code_3a:	z80_srl r16
		mov	reg_d,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3b		srl Id+d,E
;------------------------------------------------------------------------------
emu8_code_3b:	z80_srl r16
		mov	reg_e,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3c		srl Id+d,H
;------------------------------------------------------------------------------
emu8_code_3c:	z80_srl r16
		mov	reg_h,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3d		srl Id+d,L
;------------------------------------------------------------------------------
emu8_code_3d:	z80_srl r16
		mov	reg_l,r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3e		srl Id+d
;------------------------------------------------------------------------------
emu8_code_3e:	z80_srl r16
		rjmp	emu8_rflags2		;2

;------------------------------------------------------------------------------
; 0xcb 0x3f		srl Id+d,A
;------------------------------------------------------------------------------
emu8_code_3f:	z80_srl r16
		mov	reg_a,r16
		rjmp	emu8_rflags2		;2


;------------------------------------------------------------------------------
; 0xcb 0x40		BIT 0, Id+d,B
;------------------------------------------------------------------------------
emu8_code_40:	z80_bit r16,0
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x41		BIT 0, Id+d,C
;------------------------------------------------------------------------------
emu8_code_41:	z80_bit r16,0
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x42		BIT 0, Id+d,D
;------------------------------------------------------------------------------
emu8_code_42:	z80_bit r16,0
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x43		BIT 0, Id+d,E
;------------------------------------------------------------------------------
emu8_code_43:	z80_bit r16,0
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x44		BIT 0, Id+d,H
;------------------------------------------------------------------------------
emu8_code_44:	z80_bit r16,0
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x45		BIT 0, Id+d,L
;------------------------------------------------------------------------------
emu8_code_45:	z80_bit r16,0
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x46		BIT 0, Id+d
;------------------------------------------------------------------------------
emu8_code_46:	z80_bit r16,0
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x47		BIT 0, Id+d,A
;------------------------------------------------------------------------------
emu8_code_47:	z80_bit r16,0
		mov	reg_a,r16
		rjmp	emu8_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0x48		BIT 1, Id+d,B
;------------------------------------------------------------------------------
emu8_code_48:	z80_bit r16,1
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x49		BIT 1, Id+d,C
;------------------------------------------------------------------------------
emu8_code_49:	z80_bit r16,1
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4a		BIT 1, Id+d,D
;------------------------------------------------------------------------------
emu8_code_4a:	z80_bit r16,1
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4b		BIT 1, Id+d,E
;------------------------------------------------------------------------------
emu8_code_4b:	z80_bit r16,1
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4c		BIT 1, Id+d,H
;------------------------------------------------------------------------------
emu8_code_4c:	z80_bit r16,1
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4d		BIT 1, Id+d,L
;------------------------------------------------------------------------------
emu8_code_4d:	z80_bit r16,1
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4e		BIT 1, Id+d
;------------------------------------------------------------------------------
emu8_code_4e:	z80_bit r16,1
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x4f		BIT 1, Id+d,A
;------------------------------------------------------------------------------
emu8_code_4f:	z80_bit r16,1
		mov	reg_a,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x50		BIT 2, Id+d,B
;------------------------------------------------------------------------------
emu8_code_50:	z80_bit r16,2
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x51		BIT 2, Id+d,C
;------------------------------------------------------------------------------
emu8_code_51:	z80_bit r16,2
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x52		BIT 2, Id+d,D
;------------------------------------------------------------------------------
emu8_code_52:	z80_bit r16,2
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x53		BIT 2, Id+d,E
;------------------------------------------------------------------------------
emu8_code_53:	z80_bit r16,2
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x54		BIT 2, Id+d,H
;------------------------------------------------------------------------------
emu8_code_54:	z80_bit r16,2
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x55		BIT 2, Id+d,L
;------------------------------------------------------------------------------
emu8_code_55:	z80_bit r16,2
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x56		BIT 2, Id+d
;------------------------------------------------------------------------------
emu8_code_56:	z80_bit r16,2
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x57		BIT 2, Id+d,A
;------------------------------------------------------------------------------
emu8_code_57:	z80_bit r16,2
		mov	reg_a,r16
		rjmp	emu8_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0x58		BIT 3, Id+d,B
;------------------------------------------------------------------------------
emu8_code_58:	z80_bit r16,3
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x59		BIT 3, Id+d,C
;------------------------------------------------------------------------------
emu8_code_59:	z80_bit r16,3
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5a		BIT 3, Id+d,D
;------------------------------------------------------------------------------
emu8_code_5a:	z80_bit r16,3
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5b		BIT 3, Id+d,E
;------------------------------------------------------------------------------
emu8_code_5b:	z80_bit r16,3
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5c		BIT 3, Id+d,H
;------------------------------------------------------------------------------
emu8_code_5c:	z80_bit r16,3
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5d		BIT 3, Id+d,L
;------------------------------------------------------------------------------
emu8_code_5d:	z80_bit r16,3
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5e		BIT 3, Id+d
;------------------------------------------------------------------------------
emu8_code_5e:	z80_bit r16,3
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x5f		BIT 3, Id+d,A
;------------------------------------------------------------------------------
emu8_code_5f:	z80_bit r16,3
		mov	reg_a,r16
		rjmp	emu8_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0x60		BIT 4, Id+d,B
;------------------------------------------------------------------------------
emu8_code_60:	z80_bit r16,4
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x61		BIT 4, Id+d,C
;------------------------------------------------------------------------------
emu8_code_61:	z80_bit r16,4
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x62		BIT 4, Id+d,D
;------------------------------------------------------------------------------
emu8_code_62:	z80_bit r16,4
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x63		BIT 4, Id+d,E
;------------------------------------------------------------------------------
emu8_code_63:	z80_bit r16,4
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x64		BIT 4, Id+d,H
;------------------------------------------------------------------------------
emu8_code_64:	z80_bit r16,4
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x65		BIT 4, Id+d,L
;------------------------------------------------------------------------------
emu8_code_65:	z80_bit r16,4
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x66		BIT 4, Id+d
;------------------------------------------------------------------------------
emu8_code_66:	z80_bit r16,4
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x67		BIT 4, Id+d,A
;------------------------------------------------------------------------------
emu8_code_67:	z80_bit r16,4
		mov	reg_a,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x68		BIT 5, Id+d,B
;------------------------------------------------------------------------------
emu8_code_68:	z80_bit r16,5
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x69		BIT 5, Id+d,C
;------------------------------------------------------------------------------
emu8_code_69:	z80_bit r16,5
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6a		BIT 5, Id+d,D
;------------------------------------------------------------------------------
emu8_code_6a:	z80_bit r16,5
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6b		BIT 5, Id+d,E
;------------------------------------------------------------------------------
emu8_code_6b:	z80_bit r16,5
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6c		BIT 5, Id+d,H
;------------------------------------------------------------------------------
emu8_code_6c:	z80_bit r16,5
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6d		BIT 5, Id+d,L
;------------------------------------------------------------------------------
emu8_code_6d:	z80_bit r16,5
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6e		BIT 5, Id+d
;------------------------------------------------------------------------------
emu8_code_6e:	z80_bit r16,5
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x6f		BIT 5, Id+d,A
;------------------------------------------------------------------------------
emu8_code_6f:	z80_bit r16,5
		mov	reg_a,r16
		rjmp	emu8_loop		;2


;------------------------------------------------------------------------------
; 0xcb 0x70		BIT 6, Id+d,B
;------------------------------------------------------------------------------
emu8_code_70:	z80_bit r16,6
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x71		BIT 6, Id+d,C
;------------------------------------------------------------------------------
emu8_code_71:	z80_bit r16,6
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x72		BIT 6, Id+d,D
;------------------------------------------------------------------------------
emu8_code_72:	z80_bit r16,6
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x73		BIT 6, Id+d,E
;------------------------------------------------------------------------------
emu8_code_73:	z80_bit r16,6
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x74		BIT 6, Id+d,H
;------------------------------------------------------------------------------
emu8_code_74:	z80_bit r16,6
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x75		BIT 6, Id+d,L
;------------------------------------------------------------------------------
emu8_code_75:	z80_bit r16,6
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x76		BIT 6, Id+d
;------------------------------------------------------------------------------
emu8_code_76:	z80_bit r16,6
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x77		BIT 6, Id+d,A
;------------------------------------------------------------------------------
emu8_code_77:	z80_bit r16,6
		mov	reg_a,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x78		BIT 7, Id+d,B
;------------------------------------------------------------------------------
emu8_code_78:	z80_bit r16,7
		mov	reg_b,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x79		BIT 7, Id+d,C
;------------------------------------------------------------------------------
emu8_code_79:	z80_bit r16,7
		mov	reg_c,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7a		BIT 7, Id+d,D
;------------------------------------------------------------------------------
emu8_code_7a:	z80_bit r16,7
		mov	reg_d,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7b		BIT 7, Id+d,E
;------------------------------------------------------------------------------
emu8_code_7b:	z80_bit r16,7
		mov	reg_e,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7c		BIT 7, Id+d,H
;------------------------------------------------------------------------------
emu8_code_7c:	z80_bit r16,7
		mov	reg_h,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7d		BIT 7, Id+d,L
;------------------------------------------------------------------------------
emu8_code_7d:	z80_bit r16,7
		mov	reg_l,r16
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7e		BIT 7, Id+d
;------------------------------------------------------------------------------
emu8_code_7e:	z80_bit r16,7
		rjmp	emu8_loop		;2

;------------------------------------------------------------------------------
; 0xcb 0x7f		BIT 7, Id+d,A
;------------------------------------------------------------------------------
emu8_code_7f:	z80_bit r16,7
		mov	reg_a,r16
		rjmp	emu8_loop		;2


emu8_loop2:	putidbyte1 r16,r17
		getpcbyte_m1			;12/13
		ijmp				;2


emu8_rflags2:	putidbyte1 r16,r17
emu8_rflags:	ldi	ZH,HIGH(emu_flags_rot*2);1
		lpm	reg_f,Z			;3
		z80_clrnflag			;1 clear N flag
		bld	reg_f,0			;carry flag
emu8_loop:	getpcbyte_m1			;12/13
		ijmp				;2

emu8_sel:	getpcbyte r17			;offset
		getidbyte r16,r17
		getpcbyte ZL			;FCT
		ldi	ZH,HIGH(emu8_jtab)	;1
		ijmp				;2


; the level3 jump table
;------------------------------------------------------------------------------
.org (pc+255) & 0xff00

emu8_jtab:	rjmp	emu8_code_00
		rjmp	emu8_code_01
		rjmp	emu8_code_02
		rjmp	emu8_code_03
		rjmp	emu8_code_04
		rjmp	emu8_code_05
		rjmp	emu8_code_06
		rjmp	emu8_code_07
		rjmp	emu8_code_08
		rjmp	emu8_code_09
		rjmp	emu8_code_0a
		rjmp	emu8_code_0b
		rjmp	emu8_code_0c
		rjmp	emu8_code_0d
		rjmp	emu8_code_0e
		rjmp	emu8_code_0f

		rjmp	emu8_code_10
		rjmp	emu8_code_11
		rjmp	emu8_code_12
		rjmp	emu8_code_13
		rjmp	emu8_code_14
		rjmp	emu8_code_15
		rjmp	emu8_code_16
		rjmp	emu8_code_17
		rjmp	emu8_code_18
		rjmp	emu8_code_19
		rjmp	emu8_code_1a
		rjmp	emu8_code_1b
		rjmp	emu8_code_1c
		rjmp	emu8_code_1d
		rjmp	emu8_code_1e
		rjmp	emu8_code_1f

		rjmp	emu8_code_20
		rjmp	emu8_code_21
		rjmp	emu8_code_22
		rjmp	emu8_code_23
		rjmp	emu8_code_24
		rjmp	emu8_code_25
		rjmp	emu8_code_26
		rjmp	emu8_code_27
		rjmp	emu8_code_28
		rjmp	emu8_code_29
		rjmp	emu8_code_2a
		rjmp	emu8_code_2b
		rjmp	emu8_code_2c
		rjmp	emu8_code_2d
		rjmp	emu8_code_2e
		rjmp	emu8_code_2f

		rjmp	emu8_code_30
		rjmp	emu8_code_31
		rjmp	emu8_code_32
		rjmp	emu8_code_33
		rjmp	emu8_code_34
		rjmp	emu8_code_35
		rjmp	emu8_code_36
		rjmp	emu8_code_37
		rjmp	emu8_code_38
		rjmp	emu8_code_39
		rjmp	emu8_code_3a
		rjmp	emu8_code_3b
		rjmp	emu8_code_3c
		rjmp	emu8_code_3d
		rjmp	emu8_code_3e
		rjmp	emu8_code_3f

		rjmp	emu8_code_40
		rjmp	emu8_code_41
		rjmp	emu8_code_42
		rjmp	emu8_code_43
		rjmp	emu8_code_44
		rjmp	emu8_code_45
		rjmp	emu8_code_46
		rjmp	emu8_code_47
		rjmp	emu8_code_48
		rjmp	emu8_code_49
		rjmp	emu8_code_4a
		rjmp	emu8_code_4b
		rjmp	emu8_code_4c
		rjmp	emu8_code_4d
		rjmp	emu8_code_4e
		rjmp	emu8_code_4f

		rjmp	emu8_code_50
		rjmp	emu8_code_51
		rjmp	emu8_code_52
		rjmp	emu8_code_53
		rjmp	emu8_code_54
		rjmp	emu8_code_55
		rjmp	emu8_code_56
		rjmp	emu8_code_57
		rjmp	emu8_code_58
		rjmp	emu8_code_59
		rjmp	emu8_code_5a
		rjmp	emu8_code_5b
		rjmp	emu8_code_5c
		rjmp	emu8_code_5d
		rjmp	emu8_code_5e
		rjmp	emu8_code_5f

		rjmp	emu8_code_60
		rjmp	emu8_code_61
		rjmp	emu8_code_62
		rjmp	emu8_code_63
		rjmp	emu8_code_64
		rjmp	emu8_code_65
		rjmp	emu8_code_66
		rjmp	emu8_code_67
		rjmp	emu8_code_68
		rjmp	emu8_code_69
		rjmp	emu8_code_6a
		rjmp	emu8_code_6b
		rjmp	emu8_code_6c
		rjmp	emu8_code_6d
		rjmp	emu8_code_6e
		rjmp	emu8_code_6f

		rjmp	emu8_code_70
		rjmp	emu8_code_71
		rjmp	emu8_code_72
		rjmp	emu8_code_73
		rjmp	emu8_code_74
		rjmp	emu8_code_75
		rjmp	emu8_code_76
		rjmp	emu8_code_77
		rjmp	emu8_code_78
		rjmp	emu8_code_79
		rjmp	emu8_code_7a
		rjmp	emu8_code_7b
		rjmp	emu8_code_7c
		rjmp	emu8_code_7d
		rjmp	emu8_code_7e
		rjmp	emu8_code_7f

		rjmp	emu8_code_80
		rjmp	emu8_code_81
		rjmp	emu8_code_82
		rjmp	emu8_code_83
		rjmp	emu8_code_84
		rjmp	emu8_code_85
		rjmp	emu8_code_86
		rjmp	emu8_code_87
		rjmp	emu8_code_88
		rjmp	emu8_code_89
		rjmp	emu8_code_8a
		rjmp	emu8_code_8b
		rjmp	emu8_code_8c
		rjmp	emu8_code_8d
		rjmp	emu8_code_8e
		rjmp	emu8_code_8f

		rjmp	emu8_code_90
		rjmp	emu8_code_91
		rjmp	emu8_code_92
		rjmp	emu8_code_93
		rjmp	emu8_code_94
		rjmp	emu8_code_95
		rjmp	emu8_code_96
		rjmp	emu8_code_97
		rjmp	emu8_code_98
		rjmp	emu8_code_99
		rjmp	emu8_code_9a
		rjmp	emu8_code_9b
		rjmp	emu8_code_9c
		rjmp	emu8_code_9d
		rjmp	emu8_code_9e
		rjmp	emu8_code_9f

		rjmp	emu8_code_a0
		rjmp	emu8_code_a1
		rjmp	emu8_code_a2
		rjmp	emu8_code_a3
		rjmp	emu8_code_a4
		rjmp	emu8_code_a5
		rjmp	emu8_code_a6
		rjmp	emu8_code_a7
		rjmp	emu8_code_a8
		rjmp	emu8_code_a9
		rjmp	emu8_code_aa
		rjmp	emu8_code_ab
		rjmp	emu8_code_ac
		rjmp	emu8_code_ad
		rjmp	emu8_code_ae
		rjmp	emu8_code_af

		rjmp	emu8_code_b0
		rjmp	emu8_code_b1
		rjmp	emu8_code_b2
		rjmp	emu8_code_b3
		rjmp	emu8_code_b4
		rjmp	emu8_code_b5
		rjmp	emu8_code_b6
		rjmp	emu8_code_b7
		rjmp	emu8_code_b8
		rjmp	emu8_code_b9
		rjmp	emu8_code_ba
		rjmp	emu8_code_bb
		rjmp	emu8_code_bc
		rjmp	emu8_code_bd
		rjmp	emu8_code_be
		rjmp	emu8_code_bf

		rjmp	emu8_code_c0
		rjmp	emu8_code_c1
		rjmp	emu8_code_c2
		rjmp	emu8_code_c3
		rjmp	emu8_code_c4
		rjmp	emu8_code_c5
		rjmp	emu8_code_c6
		rjmp	emu8_code_c7
		rjmp	emu8_code_c8
		rjmp	emu8_code_c9
		rjmp	emu8_code_ca
		rjmp	emu8_code_cb
		rjmp	emu8_code_cc
		rjmp	emu8_code_cd
		rjmp	emu8_code_ce
		rjmp	emu8_code_cf

		rjmp	emu8_code_d0
		rjmp	emu8_code_d1
		rjmp	emu8_code_d2
		rjmp	emu8_code_d3
		rjmp	emu8_code_d4
		rjmp	emu8_code_d5
		rjmp	emu8_code_d6
		rjmp	emu8_code_d7
		rjmp	emu8_code_d8
		rjmp	emu8_code_d9
		rjmp	emu8_code_da
		rjmp	emu8_code_db
		rjmp	emu8_code_dc
		rjmp	emu8_code_dd
		rjmp	emu8_code_de
		rjmp	emu8_code_df

		rjmp	emu8_code_e0
		rjmp	emu8_code_e1
		rjmp	emu8_code_e2
		rjmp	emu8_code_e3
		rjmp	emu8_code_e4
		rjmp	emu8_code_e5
		rjmp	emu8_code_e6
		rjmp	emu8_code_e7
		rjmp	emu8_code_e8
		rjmp	emu8_code_e9
		rjmp	emu8_code_ea
		rjmp	emu8_code_eb
		rjmp	emu8_code_ec
		rjmp	emu8_code_ed
		rjmp	emu8_code_ee
		rjmp	emu8_code_ef

		rjmp	emu8_code_f0
		rjmp	emu8_code_f1
		rjmp	emu8_code_f2
		rjmp	emu8_code_f3
		rjmp	emu8_code_f4
		rjmp	emu8_code_f5
		rjmp	emu8_code_f6
		rjmp	emu8_code_f7
		rjmp	emu8_code_f8
		rjmp	emu8_code_f9
		rjmp	emu8_code_fa
		rjmp	emu8_code_fb
		rjmp	emu8_code_fc
		rjmp	emu8_code_fd
		rjmp	emu8_code_fe
		rjmp	emu8_code_ff



;------------------------------------------------------------------------------
; 0xcb 0x80		RES 0, Id+d,B
;------------------------------------------------------------------------------
emu8_code_80:	z80_res r16,0
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x81		RES 0, Id+d,C
;------------------------------------------------------------------------------
emu8_code_81:	z80_res r16,0
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x82		RES 0, Id+d,D
;------------------------------------------------------------------------------
emu8_code_82:	z80_res r16,0
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x83		RES 0, Id+d,E
;------------------------------------------------------------------------------
emu8_code_83:	z80_res r16,0
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x84		RES 0, Id+d,H
;------------------------------------------------------------------------------
emu8_code_84:	z80_res r16,0
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x85		RES 0, Id+d,L
;------------------------------------------------------------------------------
emu8_code_85:	z80_res r16,0
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x86		RES 0, Id+d
;------------------------------------------------------------------------------
emu8_code_86:	z80_res r16,0
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x87		RES 0, Id+d,A
;------------------------------------------------------------------------------
emu8_code_87:	z80_res r16,0
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0x88		RES 1, Id+d,B
;------------------------------------------------------------------------------
emu8_code_88:	z80_res r16,1
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x89		RES 1, Id+d,C
;------------------------------------------------------------------------------
emu8_code_89:	z80_res r16,1
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8a		RES 1, Id+d,D
;------------------------------------------------------------------------------
emu8_code_8a:	z80_res r16,1
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8b		RES 1, Id+d,E
;------------------------------------------------------------------------------
emu8_code_8b:	z80_res r16,1
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8c		RES 1, Id+d,H
;------------------------------------------------------------------------------
emu8_code_8c:	z80_res r16,1
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8d		RES 1, Id+d,L
;------------------------------------------------------------------------------
emu8_code_8d:	z80_res r16,1
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8e		RES 1, Id+d
;------------------------------------------------------------------------------
emu8_code_8e:	z80_res r16,1
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x8f		RES 1, Id+d,A
;------------------------------------------------------------------------------
emu8_code_8f:	z80_res r16,1
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x90		RES 2, Id+d,B
;------------------------------------------------------------------------------
emu8_code_90:	z80_res r16,2
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x91		RES 2, Id+d,C
;------------------------------------------------------------------------------
emu8_code_91:	z80_res r16,2
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x92		RES 2, Id+d,D
;------------------------------------------------------------------------------
emu8_code_92:	z80_res r16,2
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x93		RES 2, Id+d,E
;------------------------------------------------------------------------------
emu8_code_93:	z80_res r16,2
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x94		RES 2, Id+d,H
;------------------------------------------------------------------------------
emu8_code_94:	z80_res r16,2
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x95		RES 2, Id+d,L
;------------------------------------------------------------------------------
emu8_code_95:	z80_res r16,2
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x96		RES 2, Id+d
;------------------------------------------------------------------------------
emu8_code_96:	z80_res r16,2
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x97		RES 2, Id+d,A
;------------------------------------------------------------------------------
emu8_code_97:	z80_res r16,2
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0x98		RES 3, Id+d,B
;------------------------------------------------------------------------------
emu8_code_98:	z80_res r16,3
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x99		RES 3, Id+d,C
;------------------------------------------------------------------------------
emu8_code_99:	z80_res r16,3
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9a		RES 3, Id+d,D
;------------------------------------------------------------------------------
emu8_code_9a:	z80_res r16,3
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9b		RES 3, Id+d,E
;------------------------------------------------------------------------------
emu8_code_9b:	z80_res r16,3
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9c		RES 3, Id+d,H
;------------------------------------------------------------------------------
emu8_code_9c:	z80_res r16,3
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9d		RES 3, Id+d,L
;------------------------------------------------------------------------------
emu8_code_9d:	z80_res r16,3
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9e		RES 3, Id+d
;------------------------------------------------------------------------------
emu8_code_9e:	z80_res r16,3
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0x9f		RES 3, Id+d,A
;------------------------------------------------------------------------------
emu8_code_9f:	z80_res r16,3
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xa0		RES 4, Id+d,B
;------------------------------------------------------------------------------
emu8_code_a0:	z80_res r16,4
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa1		RES 4, Id+d,C
;------------------------------------------------------------------------------
emu8_code_a1:	z80_res r16,4
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa2		RES 4, Id+d,D
;------------------------------------------------------------------------------
emu8_code_a2:	z80_res r16,4
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa3		RES 4, Id+d,E
;------------------------------------------------------------------------------
emu8_code_a3:	z80_res r16,4
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa4		RES 4, Id+d,H
;------------------------------------------------------------------------------
emu8_code_a4:	z80_res r16,4
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa5		RES 4, Id+d,L
;------------------------------------------------------------------------------
emu8_code_a5:	z80_res r16,4
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa6		RES 4, Id+d
;------------------------------------------------------------------------------
emu8_code_a6:	z80_res r16,4
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa7		RES 4, Id+d,A
;------------------------------------------------------------------------------
emu8_code_a7:	z80_res r16,4
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa8		RES 5, Id+d,B
;------------------------------------------------------------------------------
emu8_code_a8:	z80_res r16,5
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xa9		RES 5, Id+d,C
;------------------------------------------------------------------------------
emu8_code_a9:	z80_res r16,5
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xaa		RES 5, Id+d,D
;------------------------------------------------------------------------------
emu8_code_aa:	z80_res r16,5
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xab		RES 5, Id+d,E
;------------------------------------------------------------------------------
emu8_code_ab:	z80_res r16,5
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xac		RES 5, Id+d,H
;------------------------------------------------------------------------------
emu8_code_ac:	z80_res r16,5
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xad		RES 5, Id+d,L
;------------------------------------------------------------------------------
emu8_code_ad:	z80_res r16,5
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xae		RES 5, Id+d
;------------------------------------------------------------------------------
emu8_code_ae:	z80_res r16,5
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xaf		RES 5, Id+d,A
;------------------------------------------------------------------------------
emu8_code_af:	z80_res r16,5
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xb0		RES 6, Id+d,B
;------------------------------------------------------------------------------
emu8_code_b0:	z80_res r16,6
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb1		RES 6, Id+d,C
;------------------------------------------------------------------------------
emu8_code_b1:	z80_res r16,6
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb2		RES 6, Id+d,D
;------------------------------------------------------------------------------
emu8_code_b2:	z80_res r16,6
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb3		RES 6, Id+d,E
;------------------------------------------------------------------------------
emu8_code_b3:	z80_res r16,6
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb4		RES 6, Id+d,H
;------------------------------------------------------------------------------
emu8_code_b4:	z80_res r16,6
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb5		RES 6, Id+d,L
;------------------------------------------------------------------------------
emu8_code_b5:	z80_res r16,6
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb6		RES 6, Id+d
;------------------------------------------------------------------------------
emu8_code_b6:	z80_res r16,6
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb7		RES 6, Id+d,A
;------------------------------------------------------------------------------
emu8_code_b7:	z80_res r16,6
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb8		RES 7, Id+d,B
;------------------------------------------------------------------------------
emu8_code_b8:	z80_res r16,7
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xb9		RES 7, Id+d,C
;------------------------------------------------------------------------------
emu8_code_b9:	z80_res r16,7
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xba		RES 7, Id+d,D
;------------------------------------------------------------------------------
emu8_code_ba:	z80_res r16,7
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xbb		RES 7, Id+d,E
;------------------------------------------------------------------------------
emu8_code_bb:	z80_res r16,7
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xbc		RES 7, Id+d,H
;------------------------------------------------------------------------------
emu8_code_bc:	z80_res r16,7
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xbd		RES 7, Id+d,L
;------------------------------------------------------------------------------
emu8_code_bd:	z80_res r16,7
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xbe		RES 7, Id+d
;------------------------------------------------------------------------------
emu8_code_be:	z80_res r16,7
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xbf		RES 7, Id+d,A
;------------------------------------------------------------------------------
emu8_code_bf:	z80_res r16,7
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xc0		SET 0, Id+d,B
;------------------------------------------------------------------------------
emu8_code_c0:	z80_set r16,0
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc1		SET 0, Id+d,C
;------------------------------------------------------------------------------
emu8_code_c1:	z80_set r16,0
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc2		SET 0, Id+d,D
;------------------------------------------------------------------------------
emu8_code_c2:	z80_set r16,0
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc3		SET 0, Id+d,E
;------------------------------------------------------------------------------
emu8_code_c3:	z80_set r16,0
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc4		SET 0, Id+d,H
;------------------------------------------------------------------------------
emu8_code_c4:	z80_set r16,0
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc5		SET 0, Id+d,L
;------------------------------------------------------------------------------
emu8_code_c5:	z80_set r16,0
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc6		SET 0, Id+d
;------------------------------------------------------------------------------
emu8_code_c6:	z80_set r16,0
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc7		SET 0, Id+d,A
;------------------------------------------------------------------------------
emu8_code_c7:	z80_set r16,0
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xc8		SET 1, Id+d,B
;------------------------------------------------------------------------------
emu8_code_c8:	z80_set r16,1
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xc9		SET 1, Id+d,C
;------------------------------------------------------------------------------
emu8_code_c9:	z80_set r16,1
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xca		SET 1, Id+d,D
;------------------------------------------------------------------------------
emu8_code_ca:	z80_set r16,1
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xcb		SET 1, Id+d,E
;------------------------------------------------------------------------------
emu8_code_cb:	z80_set r16,1
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xcc		SET 1, Id+d,H
;------------------------------------------------------------------------------
emu8_code_cc:	z80_set r16,1
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xcd		SET 1, Id+d,L
;------------------------------------------------------------------------------
emu8_code_cd:	z80_set r16,1
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xce		SET 1, Id+d
;------------------------------------------------------------------------------
emu8_code_ce:	z80_set r16,1
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xcf		SET 1, Id+d,A
;------------------------------------------------------------------------------
emu8_code_cf:	z80_set r16,1
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd0		SET 2, Id+d,B
;------------------------------------------------------------------------------
emu8_code_d0:	z80_set r16,2
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd1		SET 2, Id+d,C
;------------------------------------------------------------------------------
emu8_code_d1:	z80_set r16,2
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd2		SET 2, Id+d,D
;------------------------------------------------------------------------------
emu8_code_d2:	z80_set r16,2
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd3		SET 2, Id+d,E
;------------------------------------------------------------------------------
emu8_code_d3:	z80_set r16,2
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd4		SET 2, Id+d,H
;------------------------------------------------------------------------------
emu8_code_d4:	z80_set r16,2
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd5		SET 2, Id+d,L
;------------------------------------------------------------------------------
emu8_code_d5:	z80_set r16,2
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd6		SET 2, Id+d
;------------------------------------------------------------------------------
emu8_code_d6:	z80_set r16,2
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd7		SET 2, Id+d,A
;------------------------------------------------------------------------------
emu8_code_d7:	z80_set r16,2
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xd8		SET 3, Id+d,B
;------------------------------------------------------------------------------
emu8_code_d8:	z80_set r16,3
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xd9		SET 3, Id+d,C
;------------------------------------------------------------------------------
emu8_code_d9:	z80_set r16,3
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xda		SET 3, Id+d,D
;------------------------------------------------------------------------------
emu8_code_da:	z80_set r16,3
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xdb		SET 3, Id+d,E
;------------------------------------------------------------------------------
emu8_code_db:	z80_set r16,3
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xdc		SET 3, Id+d,H
;------------------------------------------------------------------------------
emu8_code_dc:	z80_set r16,3
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xdd		SET 3, Id+d,L
;------------------------------------------------------------------------------
emu8_code_dd:	z80_set r16,3
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xde		SET 3, Id+d
;------------------------------------------------------------------------------
emu8_code_de:	z80_set r16,3
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xdf		SET 3, Id+d,A
;------------------------------------------------------------------------------
emu8_code_df:	z80_set r16,3
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xe0		SET 4, Id+d,B
;------------------------------------------------------------------------------
emu8_code_e0:	z80_set r16,4
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe1		SET 4, Id+d,C
;------------------------------------------------------------------------------
emu8_code_e1:	z80_set r16,4
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe2		SET 4, Id+d,D
;------------------------------------------------------------------------------
emu8_code_e2:	z80_set r16,4
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe3		SET 4, Id+d,E
;------------------------------------------------------------------------------
emu8_code_e3:	z80_set r16,4
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe4		SET 4, Id+d,H
;------------------------------------------------------------------------------
emu8_code_e4:	z80_set r16,4
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe5		SET 4, Id+d,L
;------------------------------------------------------------------------------
emu8_code_e5:	z80_set r16,4
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe6		SET 4, Id+d
;------------------------------------------------------------------------------
emu8_code_e6:	z80_set r16,4
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe7		SET 4, Id+d,A
;------------------------------------------------------------------------------
emu8_code_e7:	z80_set r16,4
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe8		SET 5, Id+d,B
;------------------------------------------------------------------------------
emu8_code_e8:	z80_set r16,5
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xe9		SET 5, Id+d,C
;------------------------------------------------------------------------------
emu8_code_e9:	z80_set r16,5
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xea		SET 5, Id+d,D
;------------------------------------------------------------------------------
emu8_code_ea:	z80_set r16,5
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xeb		SET 5, Id+d,E
;------------------------------------------------------------------------------
emu8_code_eb:	z80_set r16,5
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xec		SET 5, Id+d,H
;------------------------------------------------------------------------------
emu8_code_ec:	z80_set r16,5
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xed		SET 5, Id+d,L
;------------------------------------------------------------------------------
emu8_code_ed:	z80_set r16,5
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xee		SET 5, Id+d
;------------------------------------------------------------------------------
emu8_code_ee:	z80_set r16,5
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xef		SET 5, Id+d,A
;------------------------------------------------------------------------------
emu8_code_ef:	z80_set r16,5
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


;------------------------------------------------------------------------------
; 0xcb 0xf0		SET 6, Id+d,B
;------------------------------------------------------------------------------
emu8_code_f0:	z80_set r16,6
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf1		SET 6, Id+d,C
;------------------------------------------------------------------------------
emu8_code_f1:	z80_set r16,6
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf2		SET 6, Id+d,D
;------------------------------------------------------------------------------
emu8_code_f2:	z80_set r16,6
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf3		SET 6, Id+d,E
;------------------------------------------------------------------------------
emu8_code_f3:	z80_set r16,6
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf4		SET 6, Id+d,H
;------------------------------------------------------------------------------
emu8_code_f4:	z80_set r16,6
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf5		SET 6, Id+d,L
;------------------------------------------------------------------------------
emu8_code_f5:	z80_set r16,6
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf6		SET 6, Id+d
;------------------------------------------------------------------------------
emu8_code_f6:	z80_set r16,6
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf7		SET 6, Id+d,A
;------------------------------------------------------------------------------
emu8_code_f7:	z80_set r16,6
		mov	reg_a,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf8		SET 7, Id+d,B
;------------------------------------------------------------------------------
emu8_code_f8:	z80_set r16,7
		mov	reg_b,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xf9		SET 7, Id+d,C
;------------------------------------------------------------------------------
emu8_code_f9:	z80_set r16,7
		mov	reg_c,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xfa		SET 7, Id+d,D
;------------------------------------------------------------------------------
emu8_code_fa:	z80_set r16,7
		mov	reg_d,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xfb		SET 7, Id+d,E
;------------------------------------------------------------------------------
emu8_code_fb:	z80_set r16,7
		mov	reg_e,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xfc		SET 7, Id+d,H
;------------------------------------------------------------------------------
emu8_code_fc:	z80_set r16,7
		mov	reg_h,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xfd		SET 7, Id+d,L
;------------------------------------------------------------------------------
emu8_code_fd:	z80_set r16,7
		mov	reg_l,r16
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xfe		SET 7, Id+d
;------------------------------------------------------------------------------
emu8_code_fe:	z80_set r16,7
		rjmp	emu8_loop2		;2

;------------------------------------------------------------------------------
; 0xcb 0xff		SET 7, Id+d,A
;------------------------------------------------------------------------------
emu8_code_ff:	z80_set r16,7
		mov	reg_a,r16
		rjmp	emu8_loop2		;2


