;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; load snapshot
;------------------------------------------------------------------------------
fsys_load_xrom:	sts	fsys_sectnr,const_0	;start with sector 0

fsys_rf_xr_01:	rcall	fsys_asread		;read sector
		lds	ZH,fsys_sectnr
		lsl	ZH
		ldi	ZL,HIGH(zx_ram)+4
		add	ZH,ZL
		clr	ZL
		ldi	YL,LOW(zx_ram)
		ldi	YH,HIGH(zx_ram)
		ldi	XH,0
fsys_rf_xr_02:	ld	XL,Y+
		st	Z+,XL
		ld	XL,Y+
		st	Z+,XL
		dec	XH
		brne	fsys_rf_xr_02

		lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL
		cpi	XL,17			;beyond last
		breq	fsys_chk_xrom

		lds	XL,fsys_sectnr0
		add	XL,const_1
		sts	fsys_sectnr0,XL
		lds	XL,fsys_sectnr1
		adc	XL,const_0
		sts	fsys_sectnr1,XL
		lds	XL,fsys_sectnr2
		adc	XL,const_0
		sts	fsys_sectnr2,XL
		lds	XL,fsys_sectnr3
		adc	XL,const_0
		sts	fsys_sectnr3,XL
		rjmp	fsys_rf_xr_01

fsys_chk_xrom:	clt				;no update
		out	RAMPZ,const_1
		ldi	ZL,LOW(romext*2)
		ldi	ZH,HIGH(romext*2)
		ldi	YL,LOW(zx_ram)
		ldi	YH,HIGH(zx_ram)+4
		ldi	XL,LOW(8192)
		ldi	XH,HIGH(8192)
fsys_chk_xr_1:	ld	r0,Y+
		elpm	r1,Z+
		cpse	r0,r1
		set
		sbiw	XL,1
		brne	fsys_chk_xr_1
		ret				;OK
