;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; video mode definitions for TV (common)
;--------------------------------------------------------------------------------
.if clock_freq == 12
	.equ	vsys_hint_t = 84		;horizontal INT
	.equ	vsys_hslen_t = 48		;HSYNC length
	.equ	vsys_tdelay_t = 182		;timer delay
	.equ	vsys_counter_p = 768		;12MHz / Fhor
	.equ	vsys_bend_p = 18
	.equ	vsys_counter_n = 760		;12MHz / Fhor
	.equ	vsys_bend_n = 17

.endif

.if clock_freq == 14
	.equ	vsys_hint_t = 188		;horizontal INT
	.equ	vsys_hslen_t = 60		;HSYNC length
	.equ	vsys_tdelay_t = 106		;timer delay
	.equ	vsys_counter_p = 944		;14,7456MHz / Fhor
	.equ	vsys_bend_p = 24
	.equ	vsys_counter_n = 936		;14,7456MHz / Fhor
	.equ	vsys_bend_n = 22
.endif

;--------------------------------------------------------------------------------
; video mode definitions for TV (PAL mode)
;--------------------------------------------------------------------------------
.equ	vsys_vstart_p = 241
.equ	vsys_vstop_p = 244
.equ	vsys_vbstart_p = 13
.equ	vsys_vbstop_p = 232
.equ	vsys_vlines_p = 313

;--------------------------------------------------------------------------------
; video mode definitions for TV (NTSC mode)
;--------------------------------------------------------------------------------
.equ	vsys_vstart_n = 217
.equ	vsys_vstop_n = 220
.equ	vsys_vbstart_n = 235
.equ	vsys_vbstop_n = 208
.equ	vsys_vlines_n = 262

;--------------------------------------------------------------------------------
; video mode definitions for LCD
;--------------------------------------------------------------------------------
.if clock_freq == 12
	.equ	vsys_counter_l = 995		;12MHz / Fhor
.endif
.if clock_freq == 14
	.equ	vsys_counter_l = 1020		;14..MHz / Fhor
.endif


