;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vint_tv5_fl:	lds	ZL,vsys_field
		inc	ZL
		sts	vsys_field,ZL
		sbrc	ZL,0
		add	vline_l,const_1
		rjmp	vint_tv5_end

;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;-------------------------------------------------------------------------------
vint_tv5:	sbrc	vline_h,0		;1 skip if less than 256
		rjmp	vint_tv5_01		;2 no visible line
		ldi	ZH,192
		cp	vline_l,ZH		;1 max lines
		breq	vint_tv5_fl
		brcc	vint_tv5_01		;2 goto no image-line
		rjmp	vint_tv5_10		;2 goto image line

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_tv5_01:	ldi	ZH,vsys_vstart_p	;1 vstart pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	vint_tv5_02		;no vsync start
		cbi	VSPORT,VSPIN
		sbis	GPIOR0,7		;csync bit
		rjmp	vint_tv5_end
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
		rjmp	vint_tv5_end

vint_tv5_02:	ldi	ZH,vsys_vstop_p	;1 vstop pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	vint_tv5_03		;no vsync stop
		sbi	VSPORT,VSPIN
		sbis	GPIOR0,7		;csync bit
		rjmp	vint_tv5_end
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	vint_tv5_end

vint_tv5_03:	ldi	ZH,vsys_vbstart_p	;1 border start pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vbstart_n	;1 border start ntsc
		cp	vline_l,ZH
		brne	vint_tv5_04		;no border start
		sbi	GPIOR0,4
		rjmp	vint_tv5_end

vint_tv5_04:	ldi	ZH,vsys_vbstop_p	;1 border stop pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,vsys_vbstop_n	;1 border stop ntsc
		cp	vline_l,ZH
		brne	vint_tv5_05		;no border stop
		cbi	GPIOR0,4
		sbi	GPIOR0,int_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL
		rjmp	vint_tv5_end

vint_tv5_05:	ldi	ZH,LOW(vsys_vlines_p-1)	;1 maxlines pal
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,LOW(vsys_vlines_n-1)	;1 maxlines ntsc
		cp	vline_l,ZH
		breq	vint_tv5_06		;2 end of frame
		rjmp	vint_tv5_end

vint_tv5_06:	jmp	vint_frame




;-------------------------------------------------------------------------------
;image line
;-------------------------------------------------------------------------------
vint_tv5_10:	nop
		nop
vint_tv5_11:	lds	YL,TCNT1L		;1 get timer
		sbrs	YL,0
		rjmp	vint_tv5_12
vint_tv5_12:	sbrs	YL,1
		lpm	r13,Z

vint_tv5_16:	ldi	ZL,0x18
		sts	UCSR1B,ZL
		mov	ZL,vline_l		;vline
		ldi	ZH,HIGH(spec_attr)
		lsl	ZL
		rol	ZH
		lpm	YL,Z+			;vline start
		lpm	YH,Z

		dec	ZL
		subi	ZH,0xfe			;-> pix
		lpm	XL,Z+			;vline start
		lpm	XH,Z

		ldi	ZH,32
		push	r16
		clr	r16
		lds	ZL,vsys_wait
		sbrc	ZL,4
		ldi	r16,0xff

vint_tv5_17:	ld	ZL,X+		;2 get pixline
		ld	r13,Y+		;2 get attr
		sbrs	r13,2		;1
		com	ZL		;1
		sbrc	r13,7		;1
		eor	ZL,r16		;1
		nop			;1
		nop			;1
		nop
;		ldi	ZL,0xcc			;1
		sts	UDR1,ZL		;2
		dec	ZH		;1
		brne	vint_tv5_17	;2
		pop	r16

vint_tv5_22:	sts	UCSR1B,const_0
		mov	YH,vline_l		;
		andi	YH,0x0f
		cpi	YH,0x0f
		breq	vint_tv5_end

		out	SREG,r15		;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_tv5_end:	jmp	vsys_keyb
