;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; video mode definitions for TV (common)
;--------------------------------------------------------------------------------
.if clock_freq == 24
	.equ	vsys_hint_t = 284		;horizontal INT
	.equ	vsys_hstart_t = 50		;horizontal data start
	.equ	vsys_hslen_t = 96		;HSYNC length
	.equ	vsys_tdelay_t = 176		;timer delay
.endif
.if clock_freq == 25
	.equ	vsys_hint_t = 288		;horizontal INT
	.equ	vsys_hstart_t = 58		;horizontal data start
	.equ	vsys_hslen_t = 96		;HSYNC length
	.equ	vsys_tdelay_t = 182		;timer delay
.endif

;--------------------------------------------------------------------------------
; video mode definitions for TV (PAL mode)
;--------------------------------------------------------------------------------
.if clock_freq == 24
	.equ	vsys_counter_p = 1536		;24MHz / Fhor
	.equ	vsys_bend_p = 36
.endif
.if clock_freq == 25
	.equ	vsys_counter_p = 1600		;25MHz / Fhor
	.equ	vsys_bend_p = 44
.endif

.equ	vsys_vstart_p = 241
.equ	vsys_vstop_p = 244
.equ	vsys_vbstart_p = 13
.equ	vsys_vbstop_p = 232
.equ	vsys_vlines_p = 313

;--------------------------------------------------------------------------------
; video mode definitions for TV (NTSC mode)
;--------------------------------------------------------------------------------
.if clock_freq == 24
	.equ	vsys_counter_n = 1528		;24MHz / Fhor
	.equ	vsys_bend_n = 36
.endif
.if clock_freq == 25
	.equ	vsys_counter_n = 1592		;25MHz / Fhor
	.equ	vsys_bend_n = 44
.endif

.equ	vsys_vstart_n = 217
.equ	vsys_vstop_n = 220
.equ	vsys_vbstart_n = 235
.equ	vsys_vbstop_n = 208
.equ	vsys_vlines_n = 262

;--------------------------------------------------------------------------------
; video mode definitions for VGA
;--------------------------------------------------------------------------------
.equ	vsys_counter_v = 800		;25MHz / Fhor (for all)
.equ	vsys_hslen_v = 92
.equ	vsys_hint_v = 110
.equ	vsys_hstart_v = 166

.equ	vsys_vstart_v = 221
.equ	vsys_vstop_v = 223
.equ	vsys_vbstart_v = 232
.equ	vsys_vbstop_v = 216
.equ	vsys_vlines_v = 262
.equ	vsys_bend_v = 18

.if clock_freq == 24
	.equ	vsys_tdelay_v = 183		;timer delay
.endif
.if clock_freq == 25
	.equ	vsys_tdelay_v = 181		;timer delay
.endif


;--------------------------------------------------------------------------------
; video mode definitions for LCD
;--------------------------------------------------------------------------------
.if clock_freq == 24
	.equ	vsys_counter_l = 1668		;24MHz / Fhor
.endif
.if clock_freq == 25
	.equ	vsys_counter_l = 1738		;25MHz / Fhor
.endif
