;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2012 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vint_frame:	ldi	XL,0xff
		mov	vline_l,XL		;line_l=0
		mov	vline_h,XL		;line_h=0

		lds	XL,vsys_frame
		lds	XH,vsys_fskip
		inc	XL
		andi	XL,0x07
		cp	XL,XH
		brne	vint_fnskip_ma
		jmp	vint_frame_1a
vint_fnskip_ma:

;decrement frame counter
		lds	XL,vsys_wait
		dec	XL
		sts	vsys_wait,XL

		lds	XL,vsys_led
		dec	XL
		sts	vsys_led,XL
		lds	XH,sys_blink
		and	XL,XH
		brne	vint_frnled
		ldi	XL,0x80
		out	PIND,XL

vint_frnled:
		lds	XL,vsys_keycode
		lds	XH,vsys_view
		sbrc	XH,0
		rjmp	vint_frame_nr		;no RESET if monitor view is active
		cpi	XL,0xf5			;F5=reset
.if EXT_UPDATE == 1
		sbic	PIND,2			;force RESET if external update is forced
.endif
		brne	vint_frame_nr
		ldi	XL,HIGH(emu_jrtab)
		out	OCR0A,XL
		rjmp	vsys_keyb

vint_frame_nr:	cpi	XL,0xee
		brne	vint_frame_1
		lds	XL,vsys_kbdstate
		sbrs	XL,2
		rjmp	vint_frame_1
vint_frame_res:	cli				;disable further interrupts
		rjmp	vint_frame_res

vint_frame_1:	cpi	XL,0xfc			;F12
		brne	vint_frame_1l
		sbi	PORTB,break_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL

vint_frame_1l:	cpi	XL,0xf9			;F9
		brne	vint_frame_1a
		sbi	PORTB,llist_flag	;set llist flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL

vint_frame_1a:	in	XL,GPIOR0		;config
		andi	XL,0x60			;mask out non-relevant bits
		cpi	XL,0x20
		brne	vint_frame_nlcd
		ldi	XL,VSMSK
		out	VSINP,XL

vint_frame_nlcd:
		lds	XL,vsys_view
		sbrs	XL,0
		rjmp	vint_frame_nm
		ldi	XL,0x00
		ldi	XH,sys_dfile
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH
		rjmp	vint_frame_mon

vint_frame_nm:

vint_fskip_1:	lds	XL,vsys_mode
		andi	XL,0x07
		cpi	XL,3
		brcc	vint_frmode1
		rjmp	vint_frame_81		;ZX81 mode
vint_frmode1:	brne	vint_frmode2
		rjmp	vint_frame_80		;ZX80 mode
vint_frmode2:	cpi	XL,4
		brne	vint_frmode3
		rjmp	vint_frame_JA		;ACE mode
vint_frmode3:	cpi	XL,5
		brne	vint_frmode4
		rjmp	vint_frame_SP		;spectrum mode
vint_frmode4:

;--------------------------------------------------------------------------------
; vint handling for ZX81
;--------------------------------------------------------------------------------
vint_frame_81:	lds	XL,zx_ram+0x0c		;DFILE addr
		lds	XH,zx_ram+0x0d
		andi	XH,0x3f			;max 16K
		subi	XH,0xfe			;start at 0x0200
		adiw	XL,1			;skip first HALT
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

		lds	XL,vsys_frame
		lds	XH,vsys_fskip
		inc	XL
		andi	XL,0x07
		sts	vsys_frame,XL
		cp	XL,XH
		brne	vint_fnskip_81
		sts	vsys_frame,const_0
		jmp	vint_frame_2
vint_fnskip_81:

		lds	ZL,zx_ram+0x34
		lds	ZH,zx_ram+0x35
		mov	XH,ZH
		lds	YL,vsys_nmi
		sbrc	YL,0
		sbiw	ZL,1
		andi	XH,0x80
		or	ZH,XH
		sts	zx_ram+0x34,ZL
		sts	zx_ram+0x35,ZH

		lds	YL,vsys_nmi
		sbrs	YL,0
		rjmp	vint_fr81_2

		ldi	ZL,0x19			;set margin
		sts	zx_ram+0x28,ZL

		;get keys
vint_fr81_1:	lds	ZL,vsys_keycode
		lds	ZH,vsys_lastkey
		cp	ZL,ZH
		brne	vint_fr81_k3
		lds	ZH,vsys_kpulse
		inc	ZH
		sts	vsys_kpulse,ZH
		cpi	ZH,2
		brne	vint_fr81_k4
;		sts	vsys_keycode,const_0

vint_fr81_k3:	sts	vsys_kpulse,const_0

vint_fr81_k4:	ldi	ZH,HIGH(vsys_zktable)
		lds	ZL,vsys_keycode
		lsl	ZL
		rol	ZH
		lpm	XL,Z+
		lpm	XH,Z+
		lds	ZL,vsys_kbdstate
		sbrc	ZL,2
		ori	XH,0x01
;		ldi	XL,0xff
;		ldi	XH,0xff
		sts	zx_ram+0x25,XL
		sts	zx_ram+0x26,XH
vint_fr81_k6:	lds	ZL,zx_ram+0x3b
		cbi	GPIOR0,fast_flag
		sbrs	ZL,7
		sbi	GPIOR0,fast_flag
		cpi	XL,0xff
		breq	vint_fr81_2

		ori	ZL,0x80			;set slow
		sts	zx_ram+0x3b,ZL

		lds	ZL,vsys_keycode
		cpi	ZL,0
		breq	vint_fr81_2

		lds	ZL,vsys_kwait
		sbrs	ZL,0
		rjmp	vint_fr81_2

		lds	XL,zx_ram+0x3b
		ori	XL,0x01
		sts	zx_ram+0x3b,XL
;		sts	vsys_kwait,const_0
vint_fr81_2:	call	vsys_skeys_81
		rjmp	vint_frame_2


;--------------------------------------------------------------------------------
; vint handling for ZX80
;--------------------------------------------------------------------------------
vint_frame_80:	lds	XL,zx_ram+0x0c		;DFILE addr
		lds	XH,zx_ram+0x0d
		andi	XH,0x3f			;max 16K
		subi	XH,0xfe			;start at 0x0200
		adiw	XL,1			;skip first HALT
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

		lds	XL,vsys_frame
		lds	XH,vsys_fskip
		inc	XL
		andi	XL,0x07
		sts	vsys_frame,XL
		cp	XL,XH
		brne	vint_fnskip_80
		sts	vsys_frame,const_0
		jmp	vint_frame_2
vint_fnskip_80:

		lds	ZL,zx80_venable
		sbrs	ZL,7
		dec	ZL
		sts	zx80_venable,ZL
		cbi	GPIOR0,fast_flag
		sbrc	ZL,7
		sbi	GPIOR0,fast_flag

		lds	ZL,zx_ram+0x1e
		lds	ZH,zx_ram+0x1f
		sbis	GPIOR0,fast_flag
		adiw	ZL,1
		sts	zx_ram+0x1e,ZL
		sts	zx_ram+0x1f,ZH

		;get keys
vint_fr80_1:	lds	ZL,vsys_keycode
		lds	ZH,vsys_lastkey
		cp	ZL,ZH
		brne	vint_fr80_k3
		lds	ZH,vsys_kpulse
		inc	ZH
		sts	vsys_kpulse,ZH
		cpi	ZH,10
		brne	vint_fr80_k4
;		sts	vsys_keycode,const_0

vint_fr80_k3:	sts	vsys_kpulse,const_0

vint_fr80_k4:	sts	vsys_kwait,const_0
vint_fr80_2:	call	vsys_skeys_80
		rjmp	vint_frame_2


;--------------------------------------------------------------------------------
; vint handling for ACE
;--------------------------------------------------------------------------------
vint_frame_JA:	ldi	XL,0x00
		ldi	XH,0x38
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

		call	vsys_skeys_ja
		rjmp	vint_frame_2

;--------------------------------------------------------------------------------
; vint handling for SPECTRUM
;--------------------------------------------------------------------------------
vint_frame_SP:	call	vsys_skeys_sp
		ldi	XL,0x02
		sts	vsys_rampos_h,XL
		sts	vsys_rampos_l,const_0
		ldi	XL,0x1a
		sts	vsys_apos_h,XL
		sts	vsys_apos_l,const_0
		rjmp	vint_frame_2

vint_frame_mon:	sbic	GPIOR0,6
		rjmp	vint_frame_mt		;TV
		sbic	GPIOR0,5
		rjmp	vint_frame_ml		;LCD

vint_frame_mv:	ldi	ZL,LOW(vint_vg8)
		ldi	ZH,HIGH(vint_vg8)
		out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd

vint_frame_mt:	ldi	ZL,LOW(vint_tv8)
		ldi	ZH,HIGH(vint_tv8)
		out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd

vint_frame_ml:	ldi	ZL,LOW(vint_lc8)
		ldi	ZH,HIGH(vint_lc8)
		out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd


vint_frame_2:	sbic	GPIOR0,6
		rjmp	vint_frame_10		;TV
		sbic	GPIOR0,5
		rjmp	vint_frame_20		;LCD

vint_frame_00:	ldi	ZL,LOW(vint_vg4)
		ldi	ZH,HIGH(vint_vg4)
		lds	XL,vsys_mode
		andi	XL,0x07
		cpi	XL,4			;Jupiter ACE
		breq	vint_frame_05

		ldi	ZL,LOW(vint_vg3)
		ldi	ZH,HIGH(vint_vg3)
		cpi	XL,3			;ZX80
		breq	vint_frame_05

		ldi	ZL,LOW(vint_vg5)
		ldi	ZH,HIGH(vint_vg5)
		cpi	XL,5			;SPECTRUM MONO
		breq	vint_frame_05

		ldi	ZL,LOW(vint_vg0)
		ldi	ZH,HIGH(vint_vg0)
		cpi	XL,0			;ZX81 without UDG
		breq	vint_frame_05

		lds	XL,zreg_i		;interrupt register
		cpi	XL,0x20			;limit for ROM/RAM
		brcs	vint_frame_05		;is ROM

		lds	XL,vsys_mode
		andi	XL,0x0f
		ldi	ZL,LOW(vint_vg1)
		ldi	ZH,HIGH(vint_vg1)
		cpi	XL,1			;ZX81 with UDG
		breq	vint_frame_05
		ldi	ZL,LOW(vint_vg2)
		ldi	ZH,HIGH(vint_vg2)

vint_frame_05:	out	GPIOR1,ZL
		out	GPIOR2,ZH
		jmp	vsys_keyb

vint_frame_10:	ldi	ZL,LOW(vint_tv4)
		ldi	ZH,HIGH(vint_tv4)
		lds	XL,vsys_mode
		andi	XL,0x07
		cpi	XL,4			;Jupiter ACE
		breq	vint_frame_15

		ldi	ZL,LOW(vint_tv3)
		ldi	ZH,HIGH(vint_tv3)
		cpi	XL,3			;ZX80
		breq	vint_frame_15

		ldi	ZL,LOW(vint_tv5)
		ldi	ZH,HIGH(vint_tv5)
		cpi	XL,5			;SPECTRUM mono
		breq	vint_frame_15

		ldi	ZL,LOW(vint_tv0)
		ldi	ZH,HIGH(vint_tv0)
		cpi	XL,0			;ZX81 without UDG
		breq	vint_frame_15

		lds	XL,zreg_i		;interrupt register
		cpi	XL,0x20			;limit for ROM/RAM
		brcs	vint_frame_15		;is ROM

		lds	XL,vsys_mode
		andi	XL,0x0f
		ldi	ZL,LOW(vint_tv1)
		ldi	ZH,HIGH(vint_tv1)
		cpi	XL,1			;ZX81 with UDG
		breq	vint_frame_15
		ldi	ZL,LOW(vint_tv2)
		ldi	ZH,HIGH(vint_tv2)

vint_frame_15:	out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd


vint_frame_20:	ldi	ZL,LOW(vint_lc4)
		ldi	ZH,HIGH(vint_lc4)
		lds	XL,vsys_mode
		andi	XL,0x07
		cpi	XL,4			;Jupiter ACE
		breq	vint_frame_25

		ldi	ZL,LOW(vint_lc3)
		ldi	ZH,HIGH(vint_lc3)
		cpi	XL,3			;ZX80
		breq	vint_frame_25

		ldi	ZL,LOW(vint_lc5)
		ldi	ZH,HIGH(vint_lc5)
		cpi	XL,5			;spectrum mono
		breq	vint_frame_25

		ldi	ZL,LOW(vint_lc0)
		ldi	ZH,HIGH(vint_lc0)
		cpi	XL,0			;ZX81 without UDG
		breq	vint_frame_25

		lds	XL,zreg_i		;interrupt register
		cpi	XL,0x20			;limit for ROM/RAM
		brcs	vint_frame_25		;is ROM

		lds	XL,vsys_mode
		andi	XL,0x0f
		ldi	ZL,LOW(vint_lc1)
		ldi	ZH,HIGH(vint_lc1)
		cpi	XL,1			;ZX81 with UDG
		breq	vint_frame_25
		ldi	ZL,LOW(vint_lc2)
		ldi	ZH,HIGH(vint_lc2)

vint_frame_25:	out	GPIOR1,ZL
		out	GPIOR2,ZH
vint_pkbd:;	call	vsys_setkeys		;fill key buffer
		jmp	vsys_keyb
