;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vint_lc5_fill:
		ldi	ZH,0x0a
		sbrc	vline_l,0
		ldi	ZH,0x05
		rjmp	vint_lc5_bla_0

vint_lc5_blank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

vint_lc5_bla_0:	ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
vint_lc5_bla_1:	out	DPIN,YL			;CP
		dec	XL
		out	DPIN,YL			;/CP
		brne	vint_lc5_bla_1
		sts	vsys_lastnib,ZH
		rjmp	vint_lc5_end

vint_lc5_sblank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f
		ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,1
		rjmp	vint_lc5_bla_1

vint_lc5_fblank:	clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

		ldi	ZL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
vint_lc5_fbl_1:	out	DPIN,ZL			;CP
		dec	XL
		out	DPIN,ZL			;/CP
		brne	vint_lc5_fbl_1
		ldi	ZH,0x20
		sbic	GPIOR0,7
		ldi	ZH,0x2f
		sts	vsys_lastnib,ZH
		rjmp	vint_lc5_end

;-------------------------------------------------------------------------------
; video output
;-------------------------------------------------------------------------------
vint_lc5:	cbi	DPORT,4			;enable display

;count up line counter
		ldi	YL,0x80
		lds	ZH,vsys_lastnib
		out	DPORT,ZH
		sbi	DPORT,6			;set LD
		nop
		out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		nop
		cbi	DPORT,6			;clear LD

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
		mov	ZH,vline_l
		cpi	ZH,0
		breq	vint_lc5_fblank		;first blank line
		cpi	ZH,24
		brcs	vint_lc5_sblank		;upper blank view
		cpi	ZH,216
		brcs	vint_lc5_10
		breq	vint_lc5_blank_x
		cpi	ZH,240
		brcs	vint_lc5_sblank
		sbi	GPIOR0,int_flag
		ldi	XL,HIGH(emu_jitab)
		out	OCR0A,XL
		jmp	vint_frame

vint_lc5_blank_x:	rjmp	vint_lc5_blank

;-------------------------------------------------------------------------------
; LCD output
;-------------------------------------------------------------------------------
vint_lc5_10:
		clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

		ldi	YL,0x80
		out	DPORT,ZH		;set to border
		ldi	XL,8
vint_lc5_12:	out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		dec	XL
		brne	vint_lc5_12

		mov	ZL,vline_l		;vline
		subi	ZL,24
		ldi	ZH,HIGH(spec_attr)
		lsl	ZL
		rol	ZH
		lpm	YL,Z+			;vline start
		lpm	YH,Z+

		mov	ZL,vline_l		;vline
		subi	ZL,24
		ldi	ZH,HIGH(spec_pix)
		lsl	ZL
		rol	ZH
		lpm	XL,Z+			;vline start
		lpm	XH,Z+

		push	r16
		clr	r16
		lds	ZL,vsys_wait
		sbrc	ZL,5
		ldi	r16,0xff

		push	r20			;save additional registers
		push	r21
		ldi	r20,0x80		;CP pin
		ldi	r21,32			;chars to do * 2

vint_lc5_14:	ld	ZL,X+			;2 get pixline
		ld	r13,Y+			;2 get attr
		sbrs	r13,2			;1
		com	ZL			;1
		sbrc	r13,7			;1
		eor	ZL,r16			;1

		sbis	GPIOR0,7
		com	ZL

		mov	ZH,ZL			;1 copy pixline for second nibble
		swap	ZH
		andi	ZH,0x0f		;1 mask unused bits
		out	DPORT,ZH		;1 out 4 bits
		out	DPIN,r20		;CP
		andi	ZL,0x0f		;1 mask
		out	DPIN,r20		;/CP
		out	DPORT,ZL
		out	DPIN,r20			;CP
		dec	r21
		out	DPIN,r20		;/CP
		brne	vint_lc5_14

		clr	ZH
		sbic	GPIOR0,7
		ldi	ZH,0x0f

		ldi	YL,0x80
		out	DPORT,ZH		;set to border
		ldi	XL,7
vint_lc5_15:	out	DPIN,r20		;CP
		nop
		out	DPIN,r20		;/CP
		dec	XL
		brne	vint_lc5_15

		sts	vsys_lastnib,ZH
		pop	r21
		pop	r20
		pop	r16

;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
vint_lc5_end:	jmp	vsys_keyb


