//*******************************************************************************
//*										*
//* universal microcontroller library						*
//*										*
//* copyright (c) 2010-2018 Joerg Wolfram (joerg@jcwolfram.de)			*
//*										*
//*										*
//* This program is free software; you can redistribute it and/or		*
//* modify it under the terms of the GNU General Public License			*
//* as published by the Free Software Foundation; either version 3		*
//* of the License, or (at your option) any later version.			*
//*										*
//* This program is distributed in the hope that it will be useful,		*
//* but WITHOUT ANY WARRANTY; without even the implied warranty of		*
//* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		*
//* General Public License for more details.					*
//*										*
//* You should have received a copy of the GNU General Public			*
//* License along with this library// if not, write to the			*
//* Free Software Foundation, Inc., 59 Temple Place - Suite 330,		*
//* Boston, MA 02111-1307, USA.							*
//*										*
//*******************************************************************************
#include <board.h>

volatile unsigned long unilib_lfsr1_state;	//internal
volatile unsigned long unilib_lfsr2_state;	//internal

#define LFSR_POLY1 0x78000000
#define LFSR_POLY2 0x000000C5


//#######################################################################
//#									#
//#	init lfsr default						#
//#									#
//#######################################################################
void init_lfsr_default(void)
{
	unilib_lfsr1_state = 0x4197A57C;
	unilib_lfsr2_state = 0x23456789;
}


//#######################################################################
//#									#
//#	init lfsr custom						#
//#									#
//#######################################################################
void init_lfsr_custom(unsigned long val32, unsigned long val31)
{
	unilib_lfsr1_state = val32;
	unilib_lfsr2_state = val31;
}


//#######################################################################
//#									#
//#	get random value						#
//#									#
//#######################################################################
unsigned short get_lfsr_random(void)
{
	unsigned long i;
	
	i=unilib_lfsr1_state;
	unilib_lfsr1_state >>= 1;
	if(i & 1) unilib_lfsr1_state ^= LFSR_POLY1;

	i=unilib_lfsr2_state;
	unilib_lfsr2_state <<= 1;
	if(i & 0x80000000UL) unilib_lfsr2_state ^= LFSR_POLY2;
	
	i =  unilib_lfsr1_state ^  unilib_lfsr2_state;
	
	return i & 0xFFFF;
}
